/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.RegexFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PatternTokenizer
extends LexicalTokenizer {
    private String pattern;
    private RegexFlags flags;
    private Integer group;

    public PatternTokenizer(String name) {
        super(name);
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternTokenizer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        }
        String[] flagStrings = this.flags.toString().split("\\|");
        return Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
    }

    public PatternTokenizer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    public Integer getGroup() {
        return this.group;
    }

    public PatternTokenizer setGroup(Integer group) {
        this.group = group;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PatternTokenizer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", Objects.toString((Object)this.flags, null));
        jsonWriter.writeNumberField("group", (Number)this.group);
        return jsonWriter.writeEndObject();
    }

    public static PatternTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (PatternTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String pattern = null;
            RegexFlags flags = null;
            Integer group = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.PatternTokenizer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                    continue;
                }
                if ("flags".equals(fieldName)) {
                    flags = RegexFlags.fromString(reader.getString());
                    continue;
                }
                if ("group".equals(fieldName)) {
                    group = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PatternTokenizer deserializedPatternTokenizer = new PatternTokenizer(name);
                deserializedPatternTokenizer.pattern = pattern;
                deserializedPatternTokenizer.flags = flags;
                deserializedPatternTokenizer.group = group;
                return deserializedPatternTokenizer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public PatternTokenizer setFlags(RegexFlags ... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        }
        return this.setFlags(Arrays.asList(flags));
    }
}

