/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class OutputFieldMappingEntry
implements JsonSerializable<OutputFieldMappingEntry> {
    private final String name;
    private String targetName;

    public OutputFieldMappingEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public OutputFieldMappingEntry setTargetName(String targetName) {
        this.targetName = targetName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("targetName", this.targetName);
        return jsonWriter.writeEndObject();
    }

    public static OutputFieldMappingEntry fromJson(JsonReader jsonReader) throws IOException {
        return (OutputFieldMappingEntry)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String targetName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("targetName".equals(fieldName)) {
                    targetName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                OutputFieldMappingEntry deserializedOutputFieldMappingEntry = new OutputFieldMappingEntry(name);
                deserializedOutputFieldMappingEntry.targetName = targetName;
                return deserializedOutputFieldMappingEntry;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

