/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ElisionTokenFilter
extends TokenFilter {
    private List<String> articles;

    public ElisionTokenFilter(String name) {
        super(name);
    }

    public List<String> getArticles() {
        return this.articles;
    }

    public ElisionTokenFilter setArticles(List<String> articles) {
        this.articles = articles;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.ElisionTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("articles", this.articles, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ElisionTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ElisionTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            List articles = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.ElisionTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.ElisionTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("articles".equals(fieldName)) {
                    articles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ElisionTokenFilter deserializedElisionTokenFilter = new ElisionTokenFilter(name);
                deserializedElisionTokenFilter.articles = articles;
                return deserializedElisionTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public ElisionTokenFilter setArticles(String ... articles) {
        this.articles = articles == null ? null : Arrays.asList(articles);
        return this;
    }
}

