/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public final class LuceneStandardTokenizerV1
extends LexicalTokenizer {
    private Integer maxTokenLength;

    public LuceneStandardTokenizerV1(String name) {
        super(name);
    }

    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public LuceneStandardTokenizerV1 setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.StandardTokenizer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("maxTokenLength", (Number)this.maxTokenLength);
        return jsonWriter.writeEndObject();
    }

    public static LuceneStandardTokenizerV1 fromJson(JsonReader jsonReader) throws IOException {
        return (LuceneStandardTokenizerV1)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer maxTokenLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.StandardTokenizer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StandardTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LuceneStandardTokenizerV1 deserializedLuceneStandardTokenizerV1 = new LuceneStandardTokenizerV1(name);
                deserializedLuceneStandardTokenizerV1.maxTokenLength = maxTokenLength;
                return deserializedLuceneStandardTokenizerV1;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

