/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.util.SpatialFormatter;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class SearchFilter {
    private static final ClientLogger LOGGER = new ClientLogger(SearchFilter.class);
    private static final Set<Class<?>> SAFE_CLASSES = new HashSet(20);

    public static String create(String formattableString, Object ... args) {
        if (formattableString == null) {
            return null;
        }
        if (CoreUtils.isNullOrEmpty((Object[])args)) {
            return formattableString;
        }
        return String.format(formattableString, SearchFilter.cleanseArguments(args));
    }

    private static Object[] cleanseArguments(Object ... args) {
        Object[] cleanedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            GeoPosition position;
            Object arg = args[i];
            if (arg == null) {
                cleanedArgs[i] = null;
                continue;
            }
            Class<Character> argClass = arg.getClass();
            if (Objects.equals(arg, Float.valueOf(Float.NEGATIVE_INFINITY)) || Objects.equals(arg, Double.NEGATIVE_INFINITY)) {
                cleanedArgs[i] = "-INF";
                continue;
            }
            if (Objects.equals(arg, Float.valueOf(Float.POSITIVE_INFINITY)) || Objects.equals(arg, Double.POSITIVE_INFINITY)) {
                cleanedArgs[i] = "INF";
                continue;
            }
            if (SAFE_CLASSES.contains(argClass)) {
                cleanedArgs[i] = arg;
                continue;
            }
            if (arg instanceof Date) {
                cleanedArgs[i] = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(((Date)arg).toInstant(), ZoneOffset.UTC));
                continue;
            }
            if (arg instanceof OffsetDateTime) {
                cleanedArgs[i] = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)arg);
                continue;
            }
            if (arg instanceof CharSequence) {
                cleanedArgs[i] = SearchFilter.quote(((CharSequence)arg).toString());
                continue;
            }
            if (argClass.isAssignableFrom(Character.TYPE) || arg instanceof Character) {
                cleanedArgs[i] = SearchFilter.quote(((Character)arg).toString());
                continue;
            }
            if (arg instanceof GeoPosition) {
                position = (GeoPosition)arg;
                cleanedArgs[i] = SpatialFormatter.encodePoint(position.getLongitude(), position.getLatitude());
                continue;
            }
            if (arg instanceof GeoPoint) {
                position = ((GeoPoint)arg).getCoordinates();
                cleanedArgs[i] = SpatialFormatter.encodePoint(position.getLongitude(), position.getLatitude());
                continue;
            }
            if (arg instanceof GeoLineString) {
                cleanedArgs[i] = SpatialFormatter.encodePolygon((GeoLineString)arg, LOGGER);
                continue;
            }
            if (arg instanceof GeoPolygon) {
                cleanedArgs[i] = SpatialFormatter.encodePolygon((GeoPolygon)arg, LOGGER);
                continue;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Unable to convert argument %s from type %s to an OData literal.", arg, argClass.getName())));
        }
        return cleanedArgs;
    }

    private static String quote(String text) {
        if (text == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(2 + (int)((double)text.length() * 1.05)).append("'");
        for (char ch : text.toCharArray()) {
            builder.append(ch);
            if (ch != '\'') continue;
            builder.append(ch);
        }
        return builder.append("'").toString();
    }

    private SearchFilter() {
    }

    static {
        SAFE_CLASSES.add(Boolean.TYPE);
        SAFE_CLASSES.add(Boolean.class);
        SAFE_CLASSES.add(Byte.TYPE);
        SAFE_CLASSES.add(Byte.class);
        SAFE_CLASSES.add(Short.TYPE);
        SAFE_CLASSES.add(Short.class);
        SAFE_CLASSES.add(Integer.TYPE);
        SAFE_CLASSES.add(Integer.class);
        SAFE_CLASSES.add(Long.TYPE);
        SAFE_CLASSES.add(Long.class);
        SAFE_CLASSES.add(Float.TYPE);
        SAFE_CLASSES.add(Float.class);
        SAFE_CLASSES.add(Double.TYPE);
        SAFE_CLASSES.add(Double.class);
    }
}

