/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.remoterendering.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.mixedreality.remoterendering.implementation.MixedRealityRemoteRenderingImpl;
import com.azure.mixedreality.remoterendering.implementation.models.Conversion;
import com.azure.mixedreality.remoterendering.implementation.models.CreateConversionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.CreateSessionSettings;
import com.azure.mixedreality.remoterendering.implementation.models.ErrorResponseException;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsCreateConversionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsCreateSessionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsGetConversionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsHeaders;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsNextHeaders;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsNextResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsListConversionsResponse;
import com.azure.mixedreality.remoterendering.implementation.models.RemoteRenderingsStopSessionResponse;
import com.azure.mixedreality.remoterendering.implementation.models.SessionProperties;
import com.azure.mixedreality.remoterendering.implementation.models.SessionsList;
import com.azure.mixedreality.remoterendering.implementation.models.UpdateSessionSettings;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class RemoteRenderingsImpl {
    private final RemoteRenderingsService service;
    private final MixedRealityRemoteRenderingImpl client;

    RemoteRenderingsImpl(MixedRealityRemoteRenderingImpl client) {
        this.service = (RemoteRenderingsService)RestProxy.create(RemoteRenderingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteRenderingsCreateConversionResponse> createConversionWithResponseAsync(UUID accountId, String conversionId, CreateConversionSettings body, Context context) {
        return this.service.createConversion(this.client.getEndpoint(), this.client.getApiVersion(), accountId, conversionId, body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteRenderingsGetConversionResponse> getConversionWithResponseAsync(UUID accountId, String conversionId, Context context) {
        return this.service.getConversion(this.client.getEndpoint(), this.client.getApiVersion(), accountId, conversionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Conversion>> listConversionsSinglePageAsync(UUID accountId, Context context) {
        return this.service.listConversions(this.client.getEndpoint(), this.client.getApiVersion(), accountId, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getConversions(), res.getValue().getNextLink(), (Object)((RemoteRenderingsListConversionsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteRenderingsCreateSessionResponse> createSessionWithResponseAsync(UUID accountId, String sessionId, CreateSessionSettings body, Context context) {
        return this.service.createSession(this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SessionProperties>> getSessionWithResponseAsync(UUID accountId, String sessionId, Context context) {
        return this.service.getSession(this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SessionProperties>> updateSessionWithResponseAsync(UUID accountId, String sessionId, UpdateSessionSettings body, Context context) {
        return this.service.updateSession(this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteRenderingsStopSessionResponse> stopSessionWithResponseAsync(UUID accountId, String sessionId, Context context) {
        return this.service.stopSession(this.client.getEndpoint(), this.client.getApiVersion(), accountId, sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SessionProperties>> listSessionsSinglePageAsync(UUID accountId, Context context) {
        return this.service.listSessions(this.client.getEndpoint(), this.client.getApiVersion(), accountId, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SessionsList)res.getValue()).getSessions(), ((SessionsList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<Conversion>> listConversionsNextSinglePageAsync(String nextLink, Context context) {
        return this.service.listConversionsNext(nextLink, this.client.getEndpoint(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getConversions(), res.getValue().getNextLink(), (Object)((RemoteRenderingsListConversionsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SessionProperties>> listSessionsNextSinglePageAsync(String nextLink, Context context) {
        return this.service.listSessionsNext(nextLink, this.client.getEndpoint(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SessionsList)res.getValue()).getSessions(), ((SessionsList)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="MixedRealityRemoteRe")
    public static interface RemoteRenderingsService {
        @Put(value="/accounts/{account_id}/conversions/{conversion_id}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<RemoteRenderingsCreateConversionResponse> createConversion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="conversion_id") String var4, @BodyParam(value="application/json") CreateConversionSettings var5, Context var6);

        @Get(value="/accounts/{account_id}/conversions/{conversion_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<RemoteRenderingsGetConversionResponse> getConversion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="conversion_id") String var4, Context var5);

        @Get(value="/accounts/{account_id}/conversions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<RemoteRenderingsListConversionsResponse> listConversions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, Context var4);

        @Put(value="/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<RemoteRenderingsCreateSessionResponse> createSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="session_id") String var4, @BodyParam(value="application/json") CreateSessionSettings var5, Context var6);

        @Get(value="/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SessionProperties>> getSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="session_id") String var4, Context var5);

        @Patch(value="/accounts/{account_id}/sessions/{session_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SessionProperties>> updateSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="session_id") String var4, @BodyParam(value="application/json") UpdateSessionSettings var5, Context var6);

        @Post(value="/accounts/{account_id}/sessions/{session_id}/:stop")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<RemoteRenderingsStopSessionResponse> stopSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, @PathParam(value="session_id") String var4, Context var5);

        @Get(value="/accounts/{account_id}/sessions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SessionsList>> listSessions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="account_id") UUID var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<RemoteRenderingsListConversionsNextResponse> listConversionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, Context var3);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SessionsList>> listSessionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, Context var3);
    }
}

