/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.remoterendering;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AccessToken;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.mixedreality.authentication.MixedRealityStsAsyncClient;
import com.azure.mixedreality.authentication.MixedRealityStsClientBuilder;
import com.azure.mixedreality.remoterendering.RemoteRenderingAsyncClient;
import com.azure.mixedreality.remoterendering.RemoteRenderingClient;
import com.azure.mixedreality.remoterendering.RemoteRenderingServiceVersion;
import com.azure.mixedreality.remoterendering.implementation.MixedRealityRemoteRenderingImplBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

@ServiceClientBuilder(serviceClients={RemoteRenderingClient.class, RemoteRenderingAsyncClient.class})
public final class RemoteRenderingClientBuilder {
    private final ClientLogger logger = new ClientLogger(RemoteRenderingClientBuilder.class);
    private final MixedRealityRemoteRenderingImplBuilder builder = new MixedRealityRemoteRenderingImplBuilder();
    private UUID accountId;
    private final MixedRealityStsClientBuilder stsBuilder = new MixedRealityStsClientBuilder();
    private RemoteRenderingServiceVersion apiVersion;
    private AccessToken accessToken;
    private String endpoint;
    private ClientOptions clientOptions;
    private HttpLogOptions httpLogOptions;

    public RemoteRenderingClient buildClient() {
        return new RemoteRenderingClient(this.buildAsyncClient());
    }

    public RemoteRenderingAsyncClient buildAsyncClient() {
        String scope = this.endpoint.replaceFirst("/$", "") + "/.default";
        if (this.accessToken == null) {
            MixedRealityStsAsyncClient stsClient = this.stsBuilder.buildAsyncClient();
            this.builder.addPolicy((HttpPipelinePolicy)new BearerTokenAuthenticationPolicy(r -> stsClient.getToken(), new String[]{scope}));
        } else {
            this.builder.addPolicy((HttpPipelinePolicy)new BearerTokenAuthenticationPolicy(r -> Mono.just((Object)this.accessToken), new String[]{scope}));
        }
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            this.builder.addPolicy((HttpPipelinePolicy)new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
            if (this.httpLogOptions == null) {
                this.httpLogOptions = new HttpLogOptions();
                this.httpLogOptions.addAllowedHeaderName("MS-CV");
                this.builder.httpLogOptions(this.httpLogOptions);
            }
            this.httpLogOptions.setApplicationId(this.clientOptions.getApplicationId());
        }
        return new RemoteRenderingAsyncClient(this.builder.buildClient(), this.accountId);
    }

    public RemoteRenderingClientBuilder accountId(String accountId) {
        Objects.requireNonNull(accountId, "'accountId' cannot be null.");
        try {
            this.accountId = UUID.fromString(accountId);
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The 'accountId' must be a UUID formatted value.", ex));
        }
        this.stsBuilder.accountId(accountId);
        return this;
    }

    public RemoteRenderingClientBuilder accountDomain(String accountDomain) {
        Objects.requireNonNull(accountDomain, "'accountDomain' cannot be null.");
        if (accountDomain.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'accountDomain' cannot be an empty string."));
        }
        this.stsBuilder.accountDomain(accountDomain);
        return this;
    }

    public RemoteRenderingClientBuilder credential(AzureKeyCredential accountKeyCredential) {
        this.stsBuilder.credential(Objects.requireNonNull(accountKeyCredential, "'accountKeyCredential' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder credential(TokenCredential tokenCredential) {
        this.stsBuilder.credential(Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder accessToken(AccessToken accessToken) {
        this.accessToken = Objects.requireNonNull(accessToken, "'accessToken' cannot be null.");
        return this;
    }

    public RemoteRenderingClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        this.builder.endpoint(endpoint);
        this.endpoint = endpoint;
        return this;
    }

    public RemoteRenderingClientBuilder httpClient(HttpClient httpClient) {
        this.builder.httpClient(Objects.requireNonNull(httpClient, "'httpClient' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
        this.builder.httpLogOptions(httpLogOptions);
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public RemoteRenderingClientBuilder pipeline(HttpPipeline pipeline) {
        this.builder.pipeline(Objects.requireNonNull(pipeline, "'pipeline' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.builder.retryPolicy(Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder configuration(Configuration configuration) {
        this.builder.configuration(Objects.requireNonNull(configuration, "'configuration' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.builder.addPolicy(Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null."));
        return this;
    }

    public RemoteRenderingClientBuilder serviceVersion(RemoteRenderingServiceVersion version) {
        this.apiVersion = Objects.requireNonNull(version, "'version' cannot be null.");
        return this;
    }

    public RemoteRenderingClientBuilder clientOptions(ClientOptions clientOptions) {
        Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        this.stsBuilder.clientOptions(clientOptions);
        this.clientOptions = clientOptions;
        return this;
    }
}

