/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.util.logging.ClientLogger;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class SystemProperties
implements Map<String, Object> {
    private static final ClientLogger LOGGER = new ClientLogger(SystemProperties.class);
    private final Long offset;
    private final String offsetString;
    private final String partitionKey;
    private final Instant enqueuedTime;
    private final Long sequenceNumber;
    private final AmqpAnnotatedMessage message;

    SystemProperties() {
        this.message = null;
        this.offset = null;
        this.offsetString = null;
        this.enqueuedTime = null;
        this.partitionKey = null;
        this.sequenceNumber = null;
    }

    SystemProperties(AmqpAnnotatedMessage message, String offset, Instant enqueuedTime, long sequenceNumber, String partitionKey) {
        Long parsed;
        this.message = Objects.requireNonNull(message, "'message' cannot be null.");
        this.offsetString = offset;
        this.enqueuedTime = enqueuedTime;
        this.sequenceNumber = sequenceNumber;
        this.partitionKey = partitionKey;
        try {
            parsed = this.offsetString != null && !this.offsetString.isEmpty() ? Long.valueOf(this.offsetString) : null;
        }
        catch (NumberFormatException e) {
            parsed = null;
        }
        this.offset = parsed;
    }

    @Deprecated
    Long getOffset() {
        return this.offset;
    }

    String getOffsetString() {
        return this.offsetString;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    Instant getEnqueuedTime() {
        return this.enqueuedTime;
    }

    Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public int size() {
        if (this.message == null) {
            return 0;
        }
        return this.entrySet().size();
    }

    @Override
    public Collection<Object> values() {
        if (this.message == null) {
            return Collections.emptyList();
        }
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.message == null) {
            return Collections.emptySet();
        }
        AmqpMessageProperties properties = this.message.getProperties();
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        if (properties.getMessageId() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.MESSAGE_ID.getValue(), properties.getMessageId().toString(), LOGGER));
        }
        if (properties.getUserId() != null && properties.getUserId().length > 0) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.USER_ID.getValue(), properties.getUserId(), LOGGER));
        }
        if (properties.getTo() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.TO.getValue(), properties.getTo(), LOGGER));
        }
        if (properties.getSubject() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.SUBJECT.getValue(), properties.getSubject(), LOGGER));
        }
        if (properties.getReplyTo() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.REPLY_TO.getValue(), properties.getReplyTo(), LOGGER));
        }
        if (properties.getCorrelationId() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.CORRELATION_ID.getValue(), properties.getCorrelationId().toString(), LOGGER));
        }
        if (properties.getContentType() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.CONTENT_TYPE.getValue(), properties.getContentType(), LOGGER));
        }
        if (properties.getContentEncoding() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.CONTENT_ENCODING.getValue(), properties.getContentEncoding(), LOGGER));
        }
        if (properties.getContentEncoding() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.ABSOLUTE_EXPIRY_TIME.getValue(), properties.getContentEncoding(), LOGGER));
        }
        if (properties.getCreationTime() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.CREATION_TIME.getValue(), properties.getCreationTime(), LOGGER));
        }
        if (properties.getGroupId() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.GROUP_ID.getValue(), properties.getGroupId(), LOGGER));
        }
        if (properties.getGroupSequence() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.GROUP_SEQUENCE.getValue(), properties.getGroupSequence(), LOGGER));
        }
        if (properties.getReplyToGroupId() != null) {
            entries.add(new SystemPropertiesEntry(AmqpMessageConstant.REPLY_TO_GROUP_ID.getValue(), properties.getReplyToGroupId(), LOGGER));
        }
        this.message.getMessageAnnotations().forEach((key, value) -> entries.add(new SystemPropertiesEntry((String)key, value, LOGGER)));
        return entries;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (this.message == null) {
            return defaultValue;
        }
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return this.get(key);
    }

    @Override
    public Set<String> keySet() {
        if (this.message == null) {
            return Collections.emptySet();
        }
        return this.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.message == null) {
            return false;
        }
        if (key == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'key' cannot be null"));
        }
        if (!(key instanceof String)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'key' is not a string. key: %s. class: %s", key, key.getClass())));
        }
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.message == null) {
            return false;
        }
        return this.values().contains(value);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        if (this.message == null) {
            return null;
        }
        if (key == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'key' cannot be null"));
        }
        if (!(key instanceof String)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'key' is not a string. key: %s. class: %s", key, key.getClass())));
        }
        String keyValue = (String)key;
        if (AmqpMessageConstant.MESSAGE_ID.getValue().equals(keyValue)) {
            if (this.message.getProperties().getMessageId() != null) {
                return this.message.getProperties().getMessageId().toString();
            }
            return null;
        }
        if (AmqpMessageConstant.USER_ID.getValue().equals(keyValue)) {
            return this.message.getProperties().getUserId();
        }
        if (AmqpMessageConstant.TO.getValue().equals(keyValue)) {
            if (this.message.getProperties().getTo() != null) {
                return this.message.getProperties().getTo().toString();
            }
            return null;
        }
        if (AmqpMessageConstant.SUBJECT.getValue().equals(keyValue)) {
            return this.message.getProperties().getSubject();
        }
        if (AmqpMessageConstant.REPLY_TO.getValue().equals(keyValue)) {
            if (this.message.getProperties().getReplyTo() != null) {
                return this.message.getProperties().getReplyTo().toString();
            }
            return null;
        }
        if (AmqpMessageConstant.CORRELATION_ID.getValue().equals(keyValue)) {
            if (this.message.getProperties().getCorrelationId() != null) {
                return this.message.getProperties().getCorrelationId().toString();
            }
            return null;
        }
        if (AmqpMessageConstant.CONTENT_TYPE.getValue().equals(keyValue)) {
            return this.message.getProperties().getContentType();
        }
        if (AmqpMessageConstant.CONTENT_ENCODING.getValue().equals(keyValue)) {
            return this.message.getProperties().getContentEncoding();
        }
        if (AmqpMessageConstant.ABSOLUTE_EXPIRY_TIME.getValue().equals(keyValue)) {
            return this.message.getProperties().getAbsoluteExpiryTime();
        }
        if (AmqpMessageConstant.CREATION_TIME.getValue().equals(keyValue)) {
            return this.message.getProperties().getCreationTime();
        }
        if (AmqpMessageConstant.GROUP_ID.getValue().equals(keyValue)) {
            return this.message.getProperties().getGroupId();
        }
        if (AmqpMessageConstant.GROUP_SEQUENCE.getValue().equals(keyValue)) {
            return this.message.getProperties().getGroupSequence();
        }
        if (AmqpMessageConstant.REPLY_TO_GROUP_ID.getValue().equals(keyValue)) {
            return this.message.getProperties().getReplyToGroupId();
        }
        return this.message.getMessageAnnotations().get(keyValue);
    }

    @Override
    public int hashCode() {
        if (this.message == null) {
            return super.hashCode();
        }
        return Objects.hash(this.message, this.message.getMessageAnnotations());
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public Object put(String key, Object value) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("System properties are read-only. Cannot perform 'put' operation."));
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("System properties are read-only. Cannot perform 'remove' operation."));
    }

    @Override
    public Object remove(Object key) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("System properties are read-only. Cannot perform 'remove' operation."));
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("System properties are read-only. Cannot perform 'putAll' operation."));
    }

    @Override
    public void clear() {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("System properties are read-only. Cannot perform 'clear' operation."));
    }

    private static class SystemPropertiesEntry
    implements Map.Entry<String, Object> {
        private final ClientLogger logger;
        private final String key;
        private final Object value;

        SystemPropertiesEntry(String key, Object value, ClientLogger logger) {
            this.key = key;
            this.value = value;
            this.logger = logger;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot update entry. System properties is read-only."));
        }
    }
}

