/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.messaging.eventhubs.implementation.EventHubAmqpConnection;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.implementation.EventHubReactorAmqpConnection;
import java.util.Objects;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

final class ConnectionCacheWrapper
implements Disposable {
    private final boolean isV2;
    private final ReactorConnectionCache<EventHubReactorAmqpConnection> cache;
    private final EventHubConnectionProcessor processor;

    ConnectionCacheWrapper(ReactorConnectionCache<EventHubReactorAmqpConnection> cache) {
        this.isV2 = true;
        this.cache = Objects.requireNonNull(cache, "'cache' cannot be null.");
        this.processor = null;
    }

    ConnectionCacheWrapper(EventHubConnectionProcessor processor) {
        this.isV2 = false;
        this.processor = Objects.requireNonNull(processor, "'processor' cannot be null.");
        this.cache = null;
    }

    boolean isV2() {
        return this.isV2;
    }

    Mono<EventHubAmqpConnection> getConnection() {
        return this.isV2 ? this.cache.get().cast(EventHubAmqpConnection.class) : this.processor;
    }

    String getFullyQualifiedNamespace() {
        return this.isV2 ? this.cache.getFullyQualifiedNamespace() : this.processor.getFullyQualifiedNamespace();
    }

    String getEventHubName() {
        return this.isV2 ? this.cache.getEntityPath() : this.processor.getEventHubName();
    }

    AmqpRetryOptions getRetryOptions() {
        return this.isV2 ? this.cache.getRetryOptions() : this.processor.getRetryOptions();
    }

    boolean isChannelClosed() {
        return this.isV2 ? this.cache.isCurrentConnectionClosed() : this.processor.isChannelClosed();
    }

    Mono<EventHubManagementNode> getManagementNodeWithRetries() {
        if (this.isV2) {
            AmqpRetryOptions retryOptions = this.cache.getRetryOptions();
            return RetryUtil.withRetry((Mono)this.cache.get().flatMap(EventHubReactorAmqpConnection::getManagementNode), (AmqpRetryOptions)retryOptions, (String)"Time out creating management node.");
        }
        return this.processor.getManagementNodeWithRetries();
    }

    public boolean isDisposed() {
        return this.isV2 ? this.cache.isDisposed() : this.processor.isDisposed();
    }

    public void dispose() {
        if (this.isV2) {
            this.cache.dispose();
        } else {
            this.processor.dispose();
        }
    }
}

