/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import com.azure.messaging.eventgrid.systemevents.AcsMessageButtonContent;
import com.azure.messaging.eventgrid.systemevents.AcsMessageChannelKind;
import com.azure.messaging.eventgrid.systemevents.AcsMessageContext;
import com.azure.messaging.eventgrid.systemevents.AcsMessageEventData;
import com.azure.messaging.eventgrid.systemevents.AcsMessageInteractiveContent;
import com.azure.messaging.eventgrid.systemevents.AcsMessageMediaContent;
import com.azure.messaging.eventgrid.systemevents.AcsMessageReactionContent;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public final class AcsMessageReceivedEventData
extends AcsMessageEventData {
    private String content;
    private String messageId;
    private AcsMessageChannelKind channelKind;
    private String messageType;
    private AcsMessageMediaContent mediaContent;
    private AcsMessageReactionContent reaction;
    private AcsMessageContext context;
    private AcsMessageButtonContent button;
    private AcsMessageInteractiveContent interactiveContent;

    public String getContent() {
        return this.content;
    }

    public AcsMessageReceivedEventData setContent(String content) {
        this.content = content;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public AcsMessageReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public AcsMessageChannelKind getChannelKind() {
        return this.channelKind;
    }

    public AcsMessageReceivedEventData setChannelKind(AcsMessageChannelKind channelKind) {
        this.channelKind = channelKind;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public AcsMessageReceivedEventData setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public AcsMessageMediaContent getMediaContent() {
        return this.mediaContent;
    }

    public AcsMessageReceivedEventData setMediaContent(AcsMessageMediaContent mediaContent) {
        this.mediaContent = mediaContent;
        return this;
    }

    public AcsMessageReactionContent getReaction() {
        return this.reaction;
    }

    public AcsMessageReceivedEventData setReaction(AcsMessageReactionContent reaction) {
        this.reaction = reaction;
        return this;
    }

    public AcsMessageContext getContext() {
        return this.context;
    }

    public AcsMessageReceivedEventData setContext(AcsMessageContext context) {
        this.context = context;
        return this;
    }

    public AcsMessageButtonContent getButton() {
        return this.button;
    }

    public AcsMessageReceivedEventData setButton(AcsMessageButtonContent button) {
        this.button = button;
        return this;
    }

    public AcsMessageInteractiveContent getInteractiveContent() {
        return this.interactiveContent;
    }

    public AcsMessageReceivedEventData setInteractiveContent(AcsMessageInteractiveContent interactiveContent) {
        this.interactiveContent = interactiveContent;
        return this;
    }

    @Override
    public AcsMessageReceivedEventData setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    @Override
    public AcsMessageReceivedEventData setTo(String to) {
        super.setTo(to);
        return this;
    }

    @Override
    public AcsMessageReceivedEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        super.setReceivedTimestamp(receivedTimestamp);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.getFrom());
        jsonWriter.writeStringField("to", this.getTo());
        jsonWriter.writeStringField("receivedTimestamp", this.getReceivedTimestamp() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getReceivedTimestamp()));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeStringField("messageType", this.messageType);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("channelType", this.channelKind == null ? null : this.channelKind.toString());
        jsonWriter.writeJsonField("media", (JsonSerializable)this.mediaContent);
        jsonWriter.writeJsonField("reaction", (JsonSerializable)this.reaction);
        jsonWriter.writeJsonField("context", (JsonSerializable)this.context);
        jsonWriter.writeJsonField("button", (JsonSerializable)this.button);
        jsonWriter.writeJsonField("interactive", (JsonSerializable)this.interactiveContent);
        return jsonWriter.writeEndObject();
    }

    public static AcsMessageReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsMessageReceivedEventData)jsonReader.readObject(reader -> {
            AcsMessageReceivedEventData deserializedAcsMessageReceivedEventData = new AcsMessageReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setFrom(reader.getString());
                    continue;
                }
                if ("to".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setTo(reader.getString());
                    continue;
                }
                if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setReceivedTimestamp((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.setError(AcsMessageChannelEventError.fromJson(reader));
                    continue;
                }
                if ("messageType".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.messageType = reader.getString();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.content = reader.getString();
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.messageId = reader.getString();
                    continue;
                }
                if ("channelType".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.channelKind = AcsMessageChannelKind.fromString(reader.getString());
                    continue;
                }
                if ("media".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.mediaContent = AcsMessageMediaContent.fromJson(reader);
                    continue;
                }
                if ("reaction".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.reaction = AcsMessageReactionContent.fromJson(reader);
                    continue;
                }
                if ("context".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.context = AcsMessageContext.fromJson(reader);
                    continue;
                }
                if ("button".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.button = AcsMessageButtonContent.fromJson(reader);
                    continue;
                }
                if ("interactive".equals(fieldName)) {
                    deserializedAcsMessageReceivedEventData.interactiveContent = AcsMessageInteractiveContent.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsMessageReceivedEventData;
        });
    }

    @Override
    public AcsMessageReceivedEventData setError(ResponseError error) {
        super.setError(error);
        return this;
    }
}

