/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.customtokenproxy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CustomTokenProxyHttpResponse
extends HttpResponse {
    private static final ClientLogger LOGGER = new ClientLogger(CustomTokenProxyHttpResponse.class);
    private final int statusCode;
    private final HttpHeaders headers;
    private final HttpURLConnection connection;
    private byte[] cachedResponseBodyBytes;

    public CustomTokenProxyHttpResponse(HttpRequest request, HttpURLConnection connection) {
        super(request);
        this.connection = connection;
        this.statusCode = this.extractStatusCode(connection);
        this.headers = this.extractHeaders(connection);
    }

    private HttpHeaders extractHeaders(HttpURLConnection connection) {
        HttpHeaders headers = new HttpHeaders();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String headerName = entry.getKey();
            if (headerName == null) continue;
            for (String headerValue : entry.getValue()) {
                headers.add(HttpHeaderName.fromString((String)headerName), headerValue);
            }
        }
        return headers;
    }

    private int extractStatusCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to get status code from token proxy response", e));
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(HttpHeaderName.fromString((String)name));
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.cachedResponseBodyBytes != null) {
                return this.cachedResponseBodyBytes;
            }
            InputStream stream = this.getResponseStream();
            if (stream == null) {
                this.cachedResponseBodyBytes = new byte[0];
                return this.cachedResponseBodyBytes;
            }
            try (InputStream notNullStream = stream;){
                int n;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] temp = new byte[4096];
                while ((n = notNullStream.read(temp)) != -1) {
                    buffer.write(temp, 0, n);
                }
                byte[] byArray = this.cachedResponseBodyBytes = buffer.toByteArray();
                return byArray;
            }
        });
    }

    public Flux<ByteBuffer> getBody() {
        return this.getBodyAsByteArray().flatMapMany(bytes -> Flux.just((Object)ByteBuffer.wrap(bytes)));
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsString(StandardCharsets.UTF_8);
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    public void close() {
        this.connection.disconnect();
    }

    private InputStream getResponseStream() throws IOException {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException e) {
            return this.connection.getErrorStream();
        }
    }
}

