/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.customtokenproxy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.SniSslSocketFactory;
import com.azure.identity.implementation.customtokenproxy.CustomTokenProxyHttpResponse;
import com.azure.identity.implementation.customtokenproxy.ProxyConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import reactor.core.publisher.Mono;

public class CustomTokenProxyHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(CustomTokenProxyHttpClient.class);
    private final ProxyConfig proxyConfig;
    private volatile SSLContext cachedSSLContext;
    private volatile byte[] cachedFileContentHash;
    private volatile int cachedFileContentLength;
    private volatile SSLSocketFactory cachedSslSocketFactory;
    private final URL proxyUrl;
    private final String sniName;
    private final byte[] caData;
    private final String caFile;

    public CustomTokenProxyHttpClient(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        this.proxyUrl = proxyConfig.getTokenProxyUrl();
        this.sniName = proxyConfig.getSniName();
        this.caData = proxyConfig.getCaData();
        this.caFile = proxyConfig.getCaFile();
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return Mono.fromCallable(() -> this.sendSync(request, Context.NONE));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        try {
            HttpURLConnection connection = this.createConnection(request);
            return new CustomTokenProxyHttpResponse(request, connection);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to create connection to token proxy", e));
        }
    }

    private HttpURLConnection createConnection(HttpRequest request) throws IOException {
        byte[] bytes;
        URL updatedUrl = this.rewriteTokenRequestForProxy(request.getUrl());
        HttpsURLConnection connection = (HttpsURLConnection)updatedUrl.openConnection();
        try {
            SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
            connection.setSSLSocketFactory(sslSocketFactory);
            if (!CoreUtils.isNullOrEmpty((CharSequence)this.sniName)) {
                connection.setHostnameVerifier(CustomTokenProxyHttpClient.sniAwareVerifier(this.sniName, this.proxyUrl));
            }
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to set up SSL context for token proxy", e));
        }
        String method = request.getHttpMethod().toString();
        connection.setRequestMethod(method);
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(20000);
        connection.setDoOutput(true);
        BinaryData bodyData = request.getBodyAsBinaryData();
        request.getHeaders().forEach(header -> connection.addRequestProperty(header.getName(), header.getValue()));
        if (bodyData != null && (bytes = bodyData.toBytes()) != null && bytes.length > 0) {
            try (OutputStream os = connection.getOutputStream();){
                os.write(bytes);
                os.flush();
            }
        }
        return connection;
    }

    private URL rewriteTokenRequestForProxy(URL originalUrl) throws MalformedURLException {
        try {
            String originalPath = originalUrl.getPath();
            String originalQuery = originalUrl.getQuery();
            String tokenProxyBase = this.proxyUrl.toString();
            if (!tokenProxyBase.endsWith("/")) {
                tokenProxyBase = tokenProxyBase + "/";
            }
            URI combined = URI.create(tokenProxyBase).resolve(originalPath.startsWith("/") ? originalPath.substring(1) : originalPath);
            String combinedStr = combined.toString();
            if (originalQuery != null && !originalQuery.isEmpty()) {
                combinedStr = combinedStr + "?" + originalQuery;
            }
            return URI.create(combinedStr).toURL();
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to rewrite token request for proxy", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSSLSocketFactory() {
        SSLContext sslContext = this.getSSLContext();
        if (this.cachedSslSocketFactory == null) {
            CustomTokenProxyHttpClient customTokenProxyHttpClient = this;
            synchronized (customTokenProxyHttpClient) {
                if (this.cachedSslSocketFactory == null) {
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    if (!CoreUtils.isNullOrEmpty((CharSequence)this.sniName)) {
                        sslSocketFactory = new SniSslSocketFactory(sslSocketFactory, this.sniName);
                    }
                    this.cachedSslSocketFactory = sslSocketFactory;
                }
            }
        }
        return this.cachedSslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext getSSLContext() {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)this.caFile) && (this.caData == null || this.caData.length == 0)) {
                if (this.cachedSSLContext == null) {
                    CustomTokenProxyHttpClient customTokenProxyHttpClient = this;
                    synchronized (customTokenProxyHttpClient) {
                        if (this.cachedSSLContext == null) {
                            this.cachedSSLContext = SSLContext.getDefault();
                            this.cachedSslSocketFactory = null;
                        }
                    }
                }
                return this.cachedSSLContext;
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)this.caFile)) {
                if (this.cachedSSLContext == null) {
                    CustomTokenProxyHttpClient customTokenProxyHttpClient = this;
                    synchronized (customTokenProxyHttpClient) {
                        if (this.cachedSSLContext == null) {
                            this.cachedSSLContext = this.createSslContextFromBytes(this.caData);
                            this.cachedSslSocketFactory = null;
                        }
                    }
                }
                return this.cachedSSLContext;
            }
            Path path = Paths.get(this.caFile, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw LOGGER.logExceptionAsError(new RuntimeException("CA file not found: " + this.caFile));
            }
            byte[] currentContent = Files.readAllBytes(path);
            int currentLength = currentContent.length;
            byte[] currentHash = CustomTokenProxyHttpClient.generateSHA256Hash(currentContent);
            CustomTokenProxyHttpClient customTokenProxyHttpClient = this;
            synchronized (customTokenProxyHttpClient) {
                if (currentLength == 0) {
                    if (this.cachedSSLContext == null) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("CA file " + this.caFile + " is empty"));
                    }
                    LOGGER.warning("CA file " + this.caFile + " is empty, using cached SSL context from previous load");
                    return this.cachedSSLContext;
                }
                if (this.cachedSSLContext == null || currentLength != this.cachedFileContentLength || !Arrays.equals(currentHash, this.cachedFileContentHash)) {
                    this.cachedSSLContext = this.createSslContextFromBytes(currentContent);
                    this.cachedFileContentLength = currentLength;
                    this.cachedFileContentHash = currentHash;
                    this.cachedSslSocketFactory = null;
                }
            }
            return this.cachedSSLContext;
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to initialize SSLContext for proxy", e));
        }
    }

    private SSLContext createSslContextFromBytes(byte[] certificateData) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateData);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            try {
                while (true) {
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
                    certificates.add(cert);
                }
            }
            catch (CertificateException e) {
                if (certificates.isEmpty()) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("No valid certificates found"));
                }
                SSLContext sSLContext = this.createSslContext(certificates);
                ((InputStream)inputStream).close();
                return sSLContext;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to create SSLContext from bytes", e));
            }
        }
    }

    private SSLContext createSslContext(List<X509Certificate> certificates) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, null);
            int index = 1;
            for (X509Certificate caCert : certificates) {
                keystore.setCertificateEntry("ca-cert-" + index, caCert);
                ++index;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), null);
            return context;
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to create SSLContext", e));
        }
    }

    private static HostnameVerifier sniAwareVerifier(String sniName, URL customProxyUrl) {
        return (urlHost, session) -> {
            String proxyHost;
            String peerHost = session.getPeerHost();
            if (peerHost.equalsIgnoreCase(proxyHost = customProxyUrl.getHost())) {
                if (!CoreUtils.isNullOrEmpty((CharSequence)sniName)) {
                    try {
                        Certificate[] certificates = session.getPeerCertificates();
                        if (certificates.length > 0 && certificates[0] instanceof X509Certificate) {
                            X509Certificate cert = (X509Certificate)certificates[0];
                            return CustomTokenProxyHttpClient.certificateContainsDnsName(cert, sniName);
                        }
                        return false;
                    }
                    catch (SSLPeerUnverifiedException e) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        };
    }

    private static boolean certificateContainsDnsName(X509Certificate cert, String dnsName) {
        try {
            Collection<List<?>> sanList = cert.getSubjectAlternativeNames();
            if (sanList != null) {
                for (List<?> san : sanList) {
                    String certDnsName;
                    if (san.size() < 2 || !san.get(0).equals(2) || !(certDnsName = (String)san.get(1)).equalsIgnoreCase(dnsName)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException e) {
            return false;
        }
        return false;
    }

    private static byte[] generateSHA256Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(data);
            return encodedHash;
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("SHA-256 algorithm not found", e));
        }
    }
}

