/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.CoreUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class SniSslSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sslSocketFactory;
    private final String sniName;

    public SniSslSocketFactory(SSLSocketFactory sslSocketFactory, String sniName) {
        this.sslSocketFactory = sslSocketFactory;
        this.sniName = sniName;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(s, host, port, autoClose);
        this.configureSni(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket sslSocket = this.sslSocketFactory.createSocket(host, port);
        this.configureSni(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket sslSocket = this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        this.configureSni(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket sslSocket = this.sslSocketFactory.createSocket(host, port);
        this.configureSni(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket sslSocket = this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
        this.configureSni(sslSocket);
        return sslSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    private void configureSni(Socket socket) {
        if (socket instanceof SSLSocket && !CoreUtils.isNullOrEmpty((CharSequence)this.sniName)) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new RawSniServerName(this.sniName)));
            sslSocket.setSSLParameters(sslParameters);
        }
    }

    private static final class RawSniServerName
    extends SNIServerName {
        RawSniServerName(String sniHost) {
            super(0, sniHost.getBytes(StandardCharsets.UTF_8));
        }
    }
}

