/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TableResponse
extends TableResponseProperties {
    private String odataMetadata;

    public String getOdataMetadata() {
        return this.odataMetadata;
    }

    public TableResponse setOdataMetadata(String odataMetadata) {
        this.odataMetadata = odataMetadata;
        return this;
    }

    @Override
    public TableResponse setTableName(String tableName) {
        super.setTableName(tableName);
        return this;
    }

    @Override
    public TableResponse setOdataType(String odataType) {
        super.setOdataType(odataType);
        return this;
    }

    @Override
    public TableResponse setOdataId(String odataId) {
        super.setOdataId(odataId);
        return this;
    }

    @Override
    public TableResponse setOdataEditLink(String odataEditLink) {
        super.setOdataEditLink(odataEditLink);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("TableName", this.getTableName());
        jsonWriter.writeStringField("odata.type", this.getOdataType());
        jsonWriter.writeStringField("odata.id", this.getOdataId());
        jsonWriter.writeStringField("odata.editLink", this.getOdataEditLink());
        jsonWriter.writeStringField("odata.metadata", this.odataMetadata);
        return jsonWriter.writeEndObject();
    }

    public static TableResponse fromJson(JsonReader jsonReader) throws IOException {
        return (TableResponse)jsonReader.readObject(reader -> {
            TableResponse deserializedTableResponse = new TableResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("TableName".equals(fieldName)) {
                    deserializedTableResponse.setTableName(reader.getString());
                    continue;
                }
                if ("odata.type".equals(fieldName)) {
                    deserializedTableResponse.setOdataType(reader.getString());
                    continue;
                }
                if ("odata.id".equals(fieldName)) {
                    deserializedTableResponse.setOdataId(reader.getString());
                    continue;
                }
                if ("odata.editLink".equals(fieldName)) {
                    deserializedTableResponse.setOdataEditLink(reader.getString());
                    continue;
                }
                if ("odata.metadata".equals(fieldName)) {
                    deserializedTableResponse.odataMetadata = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableResponse;
        });
    }
}

