/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.data.tables.implementation.models.ServicesGetStatisticsHeaders;
import com.azure.data.tables.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.models.TableServiceProperties;
import com.azure.data.tables.models.TableServiceStatistics;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureTableImpl client;

    ServicesImpl(AzureTableImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponseAsync(tableServiceProperties, timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, tableServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithResponseAsync(tableServiceProperties, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId, Context context) {
        return this.setPropertiesWithResponseAsync(tableServiceProperties, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.setPropertiesNoCustomHeadersWithResponseAsync(tableServiceProperties, timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(TableServiceProperties tableServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, tableServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesWithResponse(TableServiceProperties tableServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, tableServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(TableServiceProperties tableServiceProperties, Integer timeout, String requestId) {
        this.setPropertiesWithResponse(tableServiceProperties, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(TableServiceProperties tableServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, tableServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, TableServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, TableServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((TableServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServiceProperties> getPropertiesAsync(Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((TableServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetPropertiesHeaders, TableServiceProperties> getPropertiesWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceProperties getProperties(Integer timeout, String requestId) {
        return (TableServiceProperties)this.getPropertiesWithResponse(timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceProperties> getPropertiesNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, TableServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getStatisticsWithResponseAsync(timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, TableServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServiceStatistics> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((TableServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServiceStatistics> getStatisticsAsync(Integer timeout, String requestId, Context context) {
        return this.getStatisticsWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((TableServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getStatisticsNoCustomHeadersWithResponseAsync(timeout, requestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetStatisticsHeaders, TableServiceStatistics> getStatisticsWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceStatistics getStatistics(Integer timeout, String requestId) {
        return (TableServiceStatistics)this.getStatisticsWithResponse(timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceStatistics> getStatisticsNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeadersSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureTableServices")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") TableServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") TableServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") TableServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") TableServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, TableServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<Response<TableServiceProperties>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<ServicesGetPropertiesHeaders, TableServiceProperties> getPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Response<TableServiceProperties> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<ServicesGetStatisticsHeaders, TableServiceStatistics>> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<Response<TableServiceStatistics>> getStatisticsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<ServicesGetStatisticsHeaders, TableServiceStatistics> getStatisticsSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Response<TableServiceStatistics> getStatisticsNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

