/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.sas;

import java.util.Locale;

public enum TableSasProtocol {
    HTTPS_ONLY("https"),
    HTTPS_HTTP("https,http");

    private final String protocols;

    private TableSasProtocol(String p) {
        this.protocols = p;
    }

    public static TableSasProtocol parse(String str) {
        if (str.equals("https")) {
            return HTTPS_ONLY;
        }
        if (str.equals("https,http")) {
            return HTTPS_HTTP;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed into a SasProtocol value.", str));
    }

    public String toString() {
        return this.protocols;
    }
}

