/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.sas;

import com.azure.data.tables.sas.TableAccountSasPermission;
import com.azure.data.tables.sas.TableAccountSasResourceType;
import com.azure.data.tables.sas.TableAccountSasService;
import com.azure.data.tables.sas.TableSasIpRange;
import com.azure.data.tables.sas.TableSasProtocol;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class TableAccountSasSignatureValues {
    private final OffsetDateTime expiryTime;
    private final String permissions;
    private final String services;
    private final String resourceTypes;
    private String version;
    private TableSasProtocol protocol;
    private OffsetDateTime startTime;
    private TableSasIpRange sasIpRange;

    public TableAccountSasSignatureValues(OffsetDateTime expiryTime, TableAccountSasPermission permissions, TableAccountSasService services, TableAccountSasResourceType resourceTypes) {
        Objects.requireNonNull(expiryTime, "'expiryTime' cannot be null");
        Objects.requireNonNull(services, "'services' cannot be null");
        Objects.requireNonNull(permissions, "'permissions' cannot be null");
        Objects.requireNonNull(resourceTypes, "'resourceTypes' cannot be null");
        this.expiryTime = expiryTime;
        this.services = services.toString();
        this.resourceTypes = resourceTypes.toString();
        this.permissions = permissions.toString();
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getServices() {
        return this.services;
    }

    public String getResourceTypes() {
        return this.resourceTypes;
    }

    public String getVersion() {
        return this.version;
    }

    public TableAccountSasSignatureValues setVersion(String version) {
        this.version = version;
        return this;
    }

    public TableSasProtocol getProtocol() {
        return this.protocol;
    }

    public TableAccountSasSignatureValues setProtocol(TableSasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public TableAccountSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public TableSasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public TableAccountSasSignatureValues setSasIpRange(TableSasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }
}

