/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.SchemaRegistryHelper;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaFormat;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterHeaders;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SchemaRegistrySchema;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SchemaRegistryClientBuilder.class, isAsync=true)
public final class SchemaRegistryAsyncClient {
    private final ClientLogger logger = new ClientLogger(SchemaRegistryAsyncClient.class);
    private final AzureSchemaRegistryImpl restService;

    SchemaRegistryAsyncClient(AzureSchemaRegistryImpl restService) {
        this.restService = restService;
        new SchemaProperties("", com.azure.data.schemaregistry.models.SchemaFormat.AVRO);
    }

    public String getFullyQualifiedNamespace() {
        return this.restService.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaProperties> registerSchema(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return this.registerSchemaWithResponse(groupName, name, schemaDefinition, format).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaProperties>> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return FluxUtil.withContext(context -> this.registerSchemaWithResponse(groupName, name, schemaDefinition, format, (Context)context));
    }

    Mono<Response<SchemaProperties>> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'groupName' should not be null."));
        }
        if (Objects.isNull(name)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'name' should not be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaDefinition' should not be null."));
        }
        if (Objects.isNull((Object)format)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'format' should not be null."));
        }
        this.logger.verbose("Registering schema. Group: '{}', name: '{}', serialization type: '{}', payload: '{}'", new Object[]{groupName, name, format, schemaDefinition});
        BinaryData binaryData = BinaryData.fromString((String)schemaDefinition);
        SchemaFormat contentType = SchemaRegistryHelper.getContentType(format);
        return this.restService.getSchemas().registerWithResponseAsync(groupName, name, contentType.toString(), binaryData, (long)binaryData.getLength(), context).map(response -> {
            SchemaProperties registered = SchemaRegistryHelper.getSchemaProperties((SchemasRegisterHeaders)response.getDeserializedHeaders(), response.getHeaders(), format);
            return new SimpleResponse((Response)response, (Object)registered);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaRegistrySchema> getSchema(String schemaId) {
        return this.getSchemaWithResponse(schemaId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaRegistrySchema> getSchema(String groupName, String schemaName, int schemaVersion) {
        return this.getSchemaWithResponse(groupName, schemaName, schemaVersion).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String schemaId) {
        return FluxUtil.withContext(context -> this.getSchemaWithResponse(schemaId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String groupName, String schemaName, int schemaVersion) {
        return FluxUtil.withContext(context -> this.getSchemaWithResponse(groupName, schemaName, schemaVersion, (Context)context));
    }

    Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String schemaId, Context context) {
        if (Objects.isNull(schemaId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaId' should not be null."));
        }
        return this.restService.getSchemas().getByIdWithResponseAsync(schemaId, context).onErrorMap(ErrorException.class, SchemaRegistryAsyncClient::remapError).flatMap(response -> {
            SchemaProperties schemaObject = SchemaRegistryHelper.getSchemaProperties((SchemasGetByIdHeaders)response.getDeserializedHeaders(), response.getHeaders());
            return SchemaRegistryAsyncClient.convertToString((Flux<ByteBuffer>)((Flux)response.getValue()), response.getHeaders()).map(schema -> new SimpleResponse((Response)response, (Object)new SchemaRegistrySchema(schemaObject, (String)schema)));
        });
    }

    Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String groupName, String schemaName, int schemaVersion, Context context) {
        if (Objects.isNull(groupName)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'groupName' should not be null."));
        }
        return this.restService.getSchemas().getSchemaVersionWithResponseAsync(groupName, schemaName, schemaVersion, context).onErrorMap(ErrorException.class, SchemaRegistryAsyncClient::remapError).flatMap(response -> {
            Flux schemaFlux = (Flux)response.getValue();
            SchemaProperties schemaObject = SchemaRegistryHelper.getSchemaProperties((SchemasGetSchemaVersionHeaders)response.getDeserializedHeaders(), response.getHeaders());
            if (schemaFlux == null) {
                return Mono.error((Throwable)new IllegalArgumentException(String.format("Schema definition should not be null. Group Name: %s. Schema Name: %s. Version: %d", groupName, schemaName, schemaVersion)));
            }
            return SchemaRegistryAsyncClient.convertToString((Flux<ByteBuffer>)schemaFlux, response.getHeaders()).map(schema -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new SchemaRegistrySchema(schemaObject, (String)schema)));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaProperties> getSchemaProperties(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return this.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format).map(response -> (SchemaProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaProperties>> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return FluxUtil.withContext(context -> this.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format, (Context)context));
    }

    Mono<Response<SchemaProperties>> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'groupName' cannot be null."));
        }
        if (Objects.isNull(name)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'name' cannot be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaDefinition' cannot be null."));
        }
        if (Objects.isNull((Object)format)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'format' cannot be null."));
        }
        if (context == null) {
            context = Context.NONE;
        }
        BinaryData binaryData = BinaryData.fromString((String)schemaDefinition);
        SchemaFormat contentType = SchemaRegistryHelper.getContentType(format);
        return this.restService.getSchemas().queryIdByContentWithResponseAsync(groupName, name, contentType, binaryData, (long)binaryData.getLength(), context).onErrorMap(ErrorException.class, SchemaRegistryAsyncClient::remapError).map(response -> {
            SchemaProperties properties = SchemaRegistryHelper.getSchemaProperties((SchemasQueryIdByContentHeaders)response.getDeserializedHeaders(), response.getHeaders(), format);
            return new SimpleResponse((Response)response, (Object)properties);
        });
    }

    static HttpResponseException remapError(ErrorException error) {
        if (error.getResponse().getStatusCode() == 404) {
            String message = error.getValue() != null && error.getValue().getError() != null ? error.getValue().getError().getMessage() : error.getMessage();
            return new ResourceNotFoundException(message, error.getResponse(), (Throwable)((Object)error));
        }
        return error;
    }

    static Mono<String> convertToString(Flux<ByteBuffer> byteBufferFlux, HttpHeaders headers) {
        return FluxUtil.collectBytesFromNetworkResponse(byteBufferFlux, (HttpHeaders)headers).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }
}

