/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class KeyValue
implements JsonSerializable<KeyValue> {
    private String key;
    private String label;
    private String contentType;
    private String value;
    private OffsetDateTime lastModified;
    private Map<String, String> tags;
    private Boolean locked;
    private String etag;

    public String getKey() {
        return this.key;
    }

    public KeyValue setKey(String key) {
        this.key = key;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public KeyValue setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public KeyValue setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public KeyValue setValue(String value) {
        this.value = value;
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public KeyValue setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyValue setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public KeyValue setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public KeyValue setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("content_type", this.contentType);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("last_modified", this.lastModified == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModified));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("locked", this.locked);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static KeyValue fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValue)jsonReader.readObject(reader -> {
            KeyValue deserializedKeyValue = new KeyValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyValue.key = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedKeyValue.label = reader.getString();
                    continue;
                }
                if ("content_type".equals(fieldName)) {
                    deserializedKeyValue.contentType = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyValue.value = reader.getString();
                    continue;
                }
                if ("last_modified".equals(fieldName)) {
                    deserializedKeyValue.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyValue.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("locked".equals(fieldName)) {
                    deserializedKeyValue.locked = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedKeyValue.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValue;
        });
    }
}

