/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.json.JsonProviders;
import com.azure.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class ConfigurationSettingSerializationHelper {
    public static String writeSecretReferenceConfigurationSetting(SecretReferenceConfigurationSetting setting) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            block11: {
                JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    jsonWriter.writeStartObject();
                    jsonWriter.writeStringField("uri", setting.getSecretId());
                    jsonWriter.writeEndObject();
                    jsonWriter.flush();
                    string = outputStream.toString(StandardCharsets.UTF_8.name());
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
    }

    public static String writeFeatureFlagConfigurationSetting(FeatureFlagConfigurationSetting setting) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            block11: {
                JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    jsonWriter.writeStartObject();
                    jsonWriter.writeStringField("id", setting.getFeatureId());
                    jsonWriter.writeStringField("description", setting.getDescription());
                    jsonWriter.writeStringField("display_name", setting.getDisplayName());
                    jsonWriter.writeBooleanField("enabled", setting.isEnabled());
                    jsonWriter.writeStartObject("conditions");
                    jsonWriter.writeArrayField("client_filters", setting.getClientFilters(), (writer, filter) -> {
                        writer.writeStartObject();
                        writer.writeStringField("name", filter.getName());
                        writer.writeMapField("parameters", filter.getParameters(), JsonWriter::writeUntyped);
                        writer.writeEndObject();
                    });
                    jsonWriter.writeEndObject();
                    jsonWriter.writeEndObject();
                    jsonWriter.flush();
                    string = outputStream.toString(StandardCharsets.UTF_8.name());
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
    }
}

