/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.sdk.SDKThroughputControlStore;
import com.azure.cosmos.implementation.throughputControl.sdk.config.SDKThroughputControlGroupInternal;
import com.azure.cosmos.implementation.throughputControl.server.ServerThroughputControlStore;
import com.azure.cosmos.implementation.throughputControl.server.config.ServerThroughputControlGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ThroughputControlStore {
    private static final Logger logger = LoggerFactory.getLogger(ThroughputControlStore.class);
    private final SDKThroughputControlStore sdkThroughputControlStore;
    private final ServerThroughputControlStore serverThroughputControlStore;

    public ThroughputControlStore(RxClientCollectionCache collectionCache, ConnectionMode connectionMode, RxPartitionKeyRangeCache partitionKeyRangeCache) {
        Preconditions.checkNotNull(collectionCache, "RxClientCollectionCache can not be null");
        Preconditions.checkNotNull(partitionKeyRangeCache, "PartitionKeyRangeCache can not be null");
        this.sdkThroughputControlStore = new SDKThroughputControlStore(collectionCache, connectionMode, partitionKeyRangeCache);
        this.serverThroughputControlStore = new ServerThroughputControlStore();
    }

    public synchronized void enableSDKThroughputControlGroup(SDKThroughputControlGroupInternal group, Mono<Integer> throughputQueryMono) {
        String containerNameLink;
        Preconditions.checkNotNull(group, "Throughput control group cannot be null");
        if (group.isDefault() && this.serverThroughputControlStore.hasDefaultGroup(containerNameLink = Utils.trimBeginningAndEndingSlashes(BridgeInternal.extractContainerSelfLink(group.getTargetContainer())))) {
            throw new IllegalArgumentException("A default group already exists");
        }
        this.sdkThroughputControlStore.enableThroughputControlGroup(group, throughputQueryMono);
    }

    public synchronized void enableServerThroughputControlGroup(ServerThroughputControlGroup group) {
        String containerNameLink;
        Preconditions.checkNotNull(group, "Throughput control group cannot be null");
        if (group.isDefault() && this.sdkThroughputControlStore.hasDefaultGroup(containerNameLink = Utils.trimBeginningAndEndingSlashes(BridgeInternal.extractContainerSelfLink(group.getTargetContainer())))) {
            throw new IllegalArgumentException("A default group already exists");
        }
        this.serverThroughputControlStore.enableThroughputControlGroup(group);
    }

    public <T> Mono<T> processRequest(RxDocumentServiceRequest request, Mono<T> originalRequestMono) {
        Preconditions.checkNotNull(request, "Request can not be null");
        Preconditions.checkNotNull(originalRequestMono, "originalRequestMono can not be null");
        if (request.getResourceType() != ResourceType.Document && request.getResourceType() != ResourceType.StoredProcedure) {
            return originalRequestMono;
        }
        String collectionNameLink = Utils.getCollectionName(request.getResourceAddress());
        if (this.serverThroughputControlStore.hasGroup(collectionNameLink, request.getThroughputControlGroupName())) {
            return this.serverThroughputControlStore.processRequest(request, originalRequestMono);
        }
        if (this.sdkThroughputControlStore.hasGroup(collectionNameLink, request.getThroughputControlGroupName())) {
            return this.sdkThroughputControlStore.processRequest(request, originalRequestMono);
        }
        if (this.serverThroughputControlStore.hasDefaultGroup(collectionNameLink)) {
            return this.serverThroughputControlStore.processRequest(request, originalRequestMono);
        }
        if (this.sdkThroughputControlStore.hasDefaultGroup(collectionNameLink)) {
            return this.sdkThroughputControlStore.processRequest(request, originalRequestMono);
        }
        return originalRequestMono;
    }

    public void close() {
        this.sdkThroughputControlStore.close();
    }
}

