/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import java.nio.ByteBuffer;
import java.util.Objects;

public class UInt128
implements Comparable<UInt128> {
    private static final int SIZE = 128;
    private static final int BYTES = 16;
    public static final UInt128 ZERO = new UInt128(0L, 0L);
    final long low;
    final long high;

    public UInt128(long x, long y) {
        this.low = x;
        this.high = y;
    }

    public UInt128(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        this.low = byteBuffer.getLong();
        this.high = byteBuffer.getLong();
    }

    public boolean equals(Object other) {
        if (other instanceof UInt128) {
            UInt128 uInt128Other = (UInt128)other;
            return this.low == uInt128Other.low && this.high == uInt128Other.high;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(this.low).putLong(this.high);
        return byteBuffer;
    }

    public String toString() {
        return this.toByteBuffer().toString();
    }

    public long getLow() {
        return this.low;
    }

    public long getHigh() {
        return this.high;
    }

    public UInt128 add(int value) {
        UInt128 add = new UInt128(value, 0L);
        long low = this.low + add.low;
        long high = this.high + add.high;
        if (low < add.low) {
            ++high;
        }
        return new UInt128(low, high);
    }

    public UInt128 xor(UInt128 other) {
        return new UInt128(this.low ^ other.low, this.high ^ other.high);
    }

    @Override
    public int compareTo(UInt128 other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.high < other.high || this.high == other.high && this.low < other.low) {
            return -1;
        }
        return 1;
    }
}

