/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.AuthorizationTokenType;
import com.azure.cosmos.implementation.ClearingSessionContainerClientRetryPolicy;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.IRetryPolicyFactory;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.ObservableHelper;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class RxClientCollectionCache
extends RxCollectionCache {
    private final DiagnosticsClientContext diagnosticsClientContext;
    private final RxStoreModel storeModel;
    private final IAuthorizationTokenProvider tokenProvider;
    private final IRetryPolicyFactory retryPolicy;
    private final ISessionContainer sessionContainer;

    public RxClientCollectionCache(DiagnosticsClientContext diagnosticsClientContext, ISessionContainer sessionContainer, RxStoreModel storeModel, IAuthorizationTokenProvider tokenProvider, IRetryPolicyFactory retryPolicy, AsyncCache<String, DocumentCollection> collectionInfoByNameCache, AsyncCache<String, DocumentCollection> collectionInfoByIdCache) {
        super(collectionInfoByNameCache, collectionInfoByIdCache);
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.storeModel = storeModel;
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
    }

    public RxClientCollectionCache(DiagnosticsClientContext diagnosticsClientContext, ISessionContainer sessionContainer, RxStoreModel storeModel, IAuthorizationTokenProvider tokenProvider, IRetryPolicyFactory retryPolicy) {
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.storeModel = storeModel;
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
    }

    @Override
    protected Mono<DocumentCollection> getByRidAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionRid, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy(null));
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(metaDataDiagnosticsContext, PathsHelper.generatePath(ResourceType.DocumentCollection, collectionRid, false), retryPolicyInstance, properties), retryPolicyInstance);
    }

    @Override
    protected Mono<DocumentCollection> getByNameAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String resourceAddress, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy(null));
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(metaDataDiagnosticsContext, resourceAddress, retryPolicyInstance, properties), retryPolicyInstance);
    }

    private Mono<DocumentCollection> readCollectionAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String collectionLink, DocumentClientRetryPolicy retryPolicyInstance, Map<String, Object> properties) {
        String path = Utils.joinPath(collectionLink, null);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.Read, ResourceType.DocumentCollection, path, new HashMap<String, String>());
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (this.tokenProvider.getAuthorizationTokenType() != AuthorizationTokenType.AadToken) {
            String resourceName = request.getResourceAddress();
            String authorizationToken = this.tokenProvider.getUserAuthorizationToken(resourceName, request.getResourceType(), RequestVerb.GET, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, properties);
            try {
                authorizationToken = URLEncoder.encode(authorizationToken, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return Mono.error((Throwable)new IllegalStateException("Failed to encode authtoken.", e));
            }
            request.getHeaders().put("authorization", authorizationToken);
        }
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        Instant addressCallStartTime = Instant.now();
        Mono responseObs = this.tokenProvider.getAuthorizationTokenType() != AuthorizationTokenType.AadToken ? this.storeModel.processMessage(request) : this.tokenProvider.populateAuthorizationHeader(request).flatMap(serviceRequest -> this.storeModel.processMessage((RxDocumentServiceRequest)serviceRequest));
        return responseObs.map(response -> {
            DocumentCollection documentCollection = BridgeInternal.toResourceResponse(response, DocumentCollection.class).getResource();
            if (metaDataDiagnosticsContext != null) {
                Instant addressCallEndTime = Instant.now();
                MetadataDiagnosticsContext.ContainerLookupMetadataDiagnostics metaDataDiagnostic = new MetadataDiagnosticsContext.ContainerLookupMetadataDiagnostics(addressCallStartTime, addressCallEndTime, MetadataDiagnosticsContext.MetadataType.CONTAINER_LOOK_UP, request.getActivityId().toString(), documentCollection.getResourceId());
                metaDataDiagnosticsContext.addMetaDataDiagnostic(metaDataDiagnostic);
            }
            return documentCollection;
        }).single();
    }
}

