/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.UserAgentFeatureFlags;
import com.azure.cosmos.implementation.Utils;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class UserAgentContainer {
    private static final Pattern nonASCII = Pattern.compile("[^\\x00-\\x7f]");
    private static final Pattern markers = Pattern.compile("\\p{M}");
    private static final int MAX_USER_AGENT_LENGTH = 255;
    private final int maxSuffixLength;
    private final String baseUserAgent;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private String suffix;
    private String userAgent;
    private String baseUserAgentWithSuffix;
    public static final String AZSDK_USERAGENT_PREFIX = "azsdk-java-";
    public static final String BASE_USER_AGENT_STRING = Utils.getUserAgent("cosmos", HttpConstants.Versions.getSdkVersion());

    private UserAgentContainer(String sdkName, String sdkVersion) {
        this.baseUserAgent = Utils.getUserAgent(sdkName, sdkVersion);
        this.suffix = "";
        this.userAgent = this.baseUserAgent;
        this.maxSuffixLength = 254 - this.baseUserAgent.length();
    }

    public UserAgentContainer() {
        this("cosmos", HttpConstants.Versions.getSdkVersion());
    }

    public String getSuffix() {
        return this.suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatureEnabledFlagsAsSuffix(Set<UserAgentFeatureFlags> userAgentFeatureFlags) {
        if (userAgentFeatureFlags == null || userAgentFeatureFlags.isEmpty()) {
            return;
        }
        this.writeLock.lock();
        try {
            int value = 0;
            for (UserAgentFeatureFlags userAgentFeatureFlag : userAgentFeatureFlags) {
                value += userAgentFeatureFlag.getValue();
            }
            this.userAgent = !Strings.isNullOrEmpty(this.baseUserAgentWithSuffix) ? this.baseUserAgentWithSuffix : this.baseUserAgent;
            this.userAgent = this.userAgent + "|F" + Integer.toHexString(value).toUpperCase(Locale.ROOT);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setSuffix(String suffix) {
        this.writeLock.lock();
        try {
            if (suffix == null) {
                suffix = "";
            }
            if (suffix.length() > this.maxSuffixLength) {
                suffix = suffix.substring(0, this.maxSuffixLength);
            }
            this.suffix = suffix;
            this.baseUserAgentWithSuffix = this.userAgent = UserAgentContainer.stripNonAsciiCharacters(this.baseUserAgent.concat(" ").concat(this.suffix));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getUserAgent() {
        this.readLock.lock();
        try {
            String string = this.userAgent;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static String stripNonAsciiCharacters(String input) {
        String normalized = input == null ? null : Normalizer.normalize(input, Normalizer.Form.NFKD);
        String strippedMarkers = markers.matcher(normalized).replaceAll("");
        return nonASCII.matcher(strippedMarkers).replaceAll("_");
    }
}

