/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.guava25.hash.BloomFilter;
import com.azure.cosmos.implementation.guava25.hash.Funnel;
import com.azure.cosmos.implementation.guava25.hash.PrimitiveSink;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PartitionKeyBasedBloomFilter {
    private static final long EXPECTED_INSERTIONS = Configs.getPkBasedBloomFilterExpectedInsertionCount();
    private static final double ALLOWED_FALSE_POSITIVE_RATE = Configs.getPkBasedBloomFilterExpectedFfpRate();
    private BloomFilter<PartitionKeyBasedBloomFilterType> pkBasedBloomFilter;
    private final Set<String> recordedRegions = ConcurrentHashMap.newKeySet();
    private final AtomicLong bloomFilterApproximateInsertionCount;
    private final Funnel<PartitionKeyBasedBloomFilterType> funnel = new Funnel<PartitionKeyBasedBloomFilterType>(){

        @Override
        public void funnel(PartitionKeyBasedBloomFilterType from, PrimitiveSink into) {
            into.putLong(from.collectionRid).putString(from.effectivePartitionKeyString, StandardCharsets.UTF_8).putString(from.region, StandardCharsets.UTF_8);
        }
    };

    public PartitionKeyBasedBloomFilter() {
        this.pkBasedBloomFilter = BloomFilter.create(this.funnel, EXPECTED_INSERTIONS, ALLOWED_FALSE_POSITIVE_RATE);
        this.bloomFilterApproximateInsertionCount = new AtomicLong(0L);
    }

    public void tryRecordPartitionKey(RxDocumentServiceRequest request, Long collectionRid, String firstPreferredReadableRegion, String regionRoutedTo, PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition) {
        try {
            if (partitionKeyInternal == null) {
                return;
            }
            if (partitionKeyDefinition == null) {
                return;
            }
            if (Strings.isNullOrEmpty(firstPreferredReadableRegion)) {
                return;
            }
            String effectivePartitionKeyString = request.getEffectivePartitionKey() != null ? request.getEffectivePartitionKey() : PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, partitionKeyDefinition);
            String normalizedRegionRoutedTo = regionRoutedTo.toLowerCase(Locale.ROOT).replace(" ", "");
            if (!normalizedRegionRoutedTo.equals(firstPreferredReadableRegion)) {
                this.pkBasedBloomFilter.put(new PartitionKeyBasedBloomFilterType(effectivePartitionKeyString, normalizedRegionRoutedTo, collectionRid));
                this.recordedRegions.add(normalizedRegionRoutedTo);
                this.bloomFilterApproximateInsertionCount.incrementAndGet();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Set<String> tryGetPossibleRegionsLogicalPartitionResolvedTo(RxDocumentServiceRequest request, Long collectionRid, PartitionKeyInternal partitionKey, PartitionKeyDefinition partitionKeyDefinition) {
        try {
            HashSet<String> regionsPartitionKeyHasProbablySeen = new HashSet<String>();
            String effectivePartitionKeyString = request.getEffectivePartitionKey() != null ? request.getEffectivePartitionKey() : PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKey, partitionKeyDefinition);
            for (String region : this.recordedRegions) {
                if (!this.pkBasedBloomFilter.mightContain(new PartitionKeyBasedBloomFilterType(effectivePartitionKeyString, region, collectionRid))) continue;
                regionsPartitionKeyHasProbablySeen.add(region);
            }
            if (request.requestContext != null) {
                request.requestContext.setApproximateBloomFilterInsertionCount(this.bloomFilterApproximateInsertionCount.get());
            }
            return regionsPartitionKeyHasProbablySeen;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPartitionKeyResolvedToARegion(String effectivePartitionKeyString, String normalizedRegion, Long collectionRid) {
        return this.pkBasedBloomFilter.mightContain(new PartitionKeyBasedBloomFilterType(effectivePartitionKeyString, normalizedRegion, collectionRid));
    }

    public static class PartitionKeyBasedBloomFilterType {
        private final String effectivePartitionKeyString;
        private final String region;
        private final Long collectionRid;

        public PartitionKeyBasedBloomFilterType(String effectivePartitionKeyString, String region, Long collectionRid) {
            this.effectivePartitionKeyString = effectivePartitionKeyString;
            this.region = region;
            this.collectionRid = collectionRid;
        }

        public String getEffectivePartitionKeyString() {
            return this.effectivePartitionKeyString;
        }

        public String getRegion() {
            return this.region;
        }

        public Long getCollectionRid() {
            return this.collectionRid;
        }
    }
}

