/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;

public class Exceptions {
    public static boolean isStatusCode(CosmosException e, int status) {
        return status == e.getStatusCode();
    }

    public static boolean isSubStatusCode(CosmosException e, int subStatus) {
        return subStatus == e.getSubStatusCode();
    }

    public static boolean isGone(CosmosException e) {
        return Exceptions.isStatusCode(e, 410);
    }

    public static boolean isConflict(CosmosException e) {
        return Exceptions.isStatusCode(e, 409);
    }

    public static boolean isNotFound(CosmosException e) {
        return Exceptions.isStatusCode(e, 404);
    }

    public static boolean isPartitionSplitOrMerge(CosmosException e) {
        return Exceptions.isStatusCode(e, 410) && Exceptions.isSubStatusCode(e, 1002);
    }

    public static boolean isNameCacheStale(CosmosException e) {
        return Exceptions.isStatusCode(e, 410) && Exceptions.isSubStatusCode(e, 1000);
    }

    public static boolean isThroughputControlRequestRateTooLargeException(CosmosException e) {
        return Exceptions.isStatusCode(e, 429) && Exceptions.isSubStatusCode(e, 10003);
    }

    public static boolean isPartitionCompletingSplittingException(CosmosException cosmosException) {
        return Exceptions.isStatusCode(cosmosException, 410) && Exceptions.isSubStatusCode(cosmosException, 1007);
    }

    public static boolean isPartitionKeyMismatchException(CosmosException cosmosException) {
        return Exceptions.isStatusCode(cosmosException, 404) && Exceptions.isSubStatusCode(cosmosException, 1001);
    }

    public static String getInternalServerErrorMessage(String prefix) {
        return prefix + " - " + "Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support";
    }

    public static boolean isStaledResourceException(int statusCode, int subStatusCode) {
        return statusCode == 400 && subStatusCode == 1024 || statusCode == 410 && subStatusCode == 1000;
    }

    public static boolean isAvoidQuorumSelectionException(CosmosException cosmosException) {
        return Exceptions.isStatusCode(cosmosException, 410) && Exceptions.isSubStatusCode(cosmosException, 1022);
    }

    public static boolean isClientAssignedSubStatusCodeForInternalServerError(int statusCode, int subStatusCode) {
        return statusCode == 500 && subStatusCode >= 20000 && subStatusCode < 21000;
    }
}

