/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
public enum ReadConsistencyStrategy {
    DEFAULT("Default"),
    EVENTUAL("Eventual"),
    SESSION("Session"),
    LATEST_COMMITTED("LatestCommitted"),
    GLOBAL_STRONG("GlobalStrong");

    private static Map<String, ReadConsistencyStrategy> readConsistencyStrategyHashMap;
    private final String overWireValue;

    private ReadConsistencyStrategy(String overWireValue) {
        this.overWireValue = overWireValue;
    }

    static ReadConsistencyStrategy fromServiceSerializedFormat(String readConsistencyStrategy) {
        return readConsistencyStrategyHashMap.get(readConsistencyStrategy);
    }

    @JsonValue
    public String toString() {
        return this.overWireValue;
    }

    static void initialize() {
        ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.setReadConsistencyStrategyAccessor(new ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.ReadConsistencyStrategyAccessor(){

            @Override
            public ReadConsistencyStrategy createFromServiceSerializedFormat(String serviceSerializedFormat) {
                return ReadConsistencyStrategy.fromServiceSerializedFormat(serviceSerializedFormat);
            }

            @Override
            public ReadConsistencyStrategy getEffectiveReadConsistencyStrategy(ResourceType resourceType, OperationType operationType, ReadConsistencyStrategy desiredReadConsistencyStrategyOfOperation, ReadConsistencyStrategy clientLevelReadConsistencyStrategy) {
                if (resourceType != ResourceType.Document) {
                    return DEFAULT;
                }
                if (operationType.isWriteOperation()) {
                    return DEFAULT;
                }
                if (desiredReadConsistencyStrategyOfOperation != null) {
                    return desiredReadConsistencyStrategyOfOperation;
                }
                if (clientLevelReadConsistencyStrategy != null) {
                    return clientLevelReadConsistencyStrategy;
                }
                return DEFAULT;
            }
        });
    }

    static {
        readConsistencyStrategyHashMap = new HashMap<String, ReadConsistencyStrategy>();
        for (ReadConsistencyStrategy rcs : ReadConsistencyStrategy.values()) {
            readConsistencyStrategyHashMap.put(rcs.toString(), rcs);
        }
        ReadConsistencyStrategy.initialize();
    }
}

