/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.AvailabilityStrategy;
import java.time.Duration;

public final class CosmosEndToEndOperationLatencyPolicyConfig {
    private final boolean isEnabled;
    private final Duration endToEndOperationTimeout;
    private final AvailabilityStrategy availabilityStrategy;
    private final String toStringValue;

    CosmosEndToEndOperationLatencyPolicyConfig(boolean isEnabled, Duration endToEndOperationTimeout, AvailabilityStrategy availabilityStrategy) {
        this.isEnabled = isEnabled;
        this.endToEndOperationTimeout = endToEndOperationTimeout;
        this.availabilityStrategy = availabilityStrategy;
        this.toStringValue = this.createStringRepresentation();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Duration getEndToEndOperationTimeout() {
        return this.endToEndOperationTimeout;
    }

    public AvailabilityStrategy getAvailabilityStrategy() {
        return this.availabilityStrategy;
    }

    public String toString() {
        return this.toStringValue;
    }

    private String createStringRepresentation() {
        if (this.endToEndOperationTimeout == null) {
            return "";
        }
        String availabilityStrategyAsString = "";
        if (this.availabilityStrategy != null) {
            availabilityStrategyAsString = this.availabilityStrategy.toString();
        }
        return "{e2eto=" + this.endToEndOperationTimeout + ", as=" + availabilityStrategyAsString + "}";
    }
}

