/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.server.controller;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.IThroughputController;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlRequestContext;
import com.azure.cosmos.implementation.throughputControl.server.config.ServerThroughputControlGroup;
import reactor.core.publisher.Mono;

public class ServerThroughputGroupController
implements IThroughputController {
    private final ServerThroughputControlGroup serverThroughputControlGroup;

    public ServerThroughputGroupController(ServerThroughputControlGroup serverThroughputControlGroup) {
        Preconditions.checkNotNull(serverThroughputControlGroup, "Argument 'serverThroughputControlGroup' cannot be null.");
        this.serverThroughputControlGroup = serverThroughputControlGroup;
    }

    @Override
    public boolean canHandleRequest(RxDocumentServiceRequest request) {
        return true;
    }

    @Override
    public <T> Mono<T> init() {
        return Mono.just((Object)this);
    }

    @Override
    public <T> Mono<T> processRequest(RxDocumentServiceRequest request, Mono<T> originalRequestMono) {
        if (this.serverThroughputControlGroup.getPriorityLevel() != null) {
            request.setPriorityLevel(this.serverThroughputControlGroup.getPriorityLevel());
        }
        if (this.serverThroughputControlGroup.getThroughputBucket() != null) {
            request.setThroughputBucket(this.serverThroughputControlGroup.getThroughputBucket());
        }
        if (request.requestContext != null) {
            request.requestContext.setThroughputControlRequestContext(new ThroughputControlRequestContext(this.serverThroughputControlGroup.getDiagnosticsString()));
        }
        return originalRequestMono;
    }

    public boolean isDefault() {
        return this.serverThroughputControlGroup.isDefault();
    }
}

