/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.sdk;

import com.azure.cosmos.implementation.throughputControl.sdk.LinkedCancellationToken;
import java.io.Closeable;

public class LinkedCancellationTokenSource
implements Closeable {
    private boolean tokenSourceClosed = false;
    private LinkedCancellationToken parentToken;

    public LinkedCancellationTokenSource() {
        this(null);
    }

    public LinkedCancellationTokenSource(LinkedCancellationToken parent) {
        if (parent != null) {
            parent.register(this);
            this.parentToken = parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedCancellationToken getToken() {
        LinkedCancellationTokenSource linkedCancellationTokenSource = this;
        synchronized (linkedCancellationTokenSource) {
            if (this.tokenSourceClosed) {
                throw new IllegalStateException("The cancellation token resource has been closed");
            }
            return new LinkedCancellationToken(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        LinkedCancellationTokenSource linkedCancellationTokenSource = this;
        synchronized (linkedCancellationTokenSource) {
            return this.tokenSourceClosed || this.parentToken != null && this.parentToken.isCancellationRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedCancellationTokenSource linkedCancellationTokenSource = this;
        synchronized (linkedCancellationTokenSource) {
            this.tokenSourceClosed = true;
        }
    }
}

