/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.net.URI;
import java.util.List;

public abstract class FaultInjectionRequestArgs {
    private final long transportRequestId;
    private final URI requestURI;
    private final RxDocumentServiceRequest serviceRequest;
    private boolean isPrimary;

    public FaultInjectionRequestArgs(long transportRequestId, URI requestURI, boolean isPrimary, RxDocumentServiceRequest serviceRequest) {
        Preconditions.checkNotNull(requestURI, "Argument 'requestURI' can not null");
        Preconditions.checkNotNull(serviceRequest, "Argument 'serviceRequest' can not be null");
        this.transportRequestId = transportRequestId;
        this.requestURI = requestURI;
        this.isPrimary = isPrimary;
        this.serviceRequest = serviceRequest;
    }

    public long getTransportRequestId() {
        return this.transportRequestId;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public RxDocumentServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public abstract List<String> getPartitionKeyRangeIds();

    public abstract String getCollectionRid();
}

