/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosDaemonThreadFactory;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountLocation;
import com.azure.cosmos.implementation.DatabaseAccountManagerInternal;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.routing.LocationCache;
import com.azure.cosmos.implementation.routing.LocationHelper;
import com.azure.cosmos.implementation.routing.RegionalRoutingContext;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class GlobalEndpointManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private static final CosmosDaemonThreadFactory theadFactory = new CosmosDaemonThreadFactory("cosmos-global-endpoint-mgr");
    private final int backgroundRefreshLocationTimeIntervalInMS;
    private final LocationCache locationCache;
    private final URI defaultEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final Duration maxInitializationTime;
    private final DatabaseAccountManagerInternal owner;
    private final AtomicBoolean isRefreshing;
    private final AtomicBoolean refreshInBackground;
    private final Scheduler scheduler = Schedulers.newSingle((ThreadFactory)theadFactory);
    private volatile boolean isClosed;
    private volatile DatabaseAccount latestDatabaseAccount;
    private final AtomicBoolean hasThinClientReadLocations = new AtomicBoolean(false);
    private final ReentrantReadWriteLock.WriteLock databaseAccountWriteLock;
    private final ReentrantReadWriteLock.ReadLock databaseAccountReadLock;
    private volatile Throwable latestDatabaseRefreshError;

    public void setLatestDatabaseRefreshError(Throwable latestDatabaseRefreshError) {
        this.latestDatabaseRefreshError = latestDatabaseRefreshError;
    }

    public Throwable getLatestDatabaseRefreshError() {
        return this.latestDatabaseRefreshError;
    }

    public GlobalEndpointManager(DatabaseAccountManagerInternal owner, ConnectionPolicy connectionPolicy, Configs configs) {
        this.backgroundRefreshLocationTimeIntervalInMS = configs.getUnavailableLocationsExpirationTimeInSeconds() * 1000;
        this.maxInitializationTime = Duration.ofSeconds(configs.getGlobalEndpointManagerMaxInitializationTimeInSeconds());
        try {
            this.locationCache = new LocationCache(connectionPolicy, owner.getServiceEndpoint(), configs);
            this.owner = owner;
            this.defaultEndpoint = owner.getServiceEndpoint();
            this.connectionPolicy = connectionPolicy;
            this.isRefreshing = new AtomicBoolean(false);
            this.refreshInBackground = new AtomicBoolean(false);
            this.isClosed = false;
            ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
            this.databaseAccountWriteLock = reentrantReadWriteLock.writeLock();
            this.databaseAccountReadLock = reentrantReadWriteLock.readLock();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void init() {
        this.startRefreshLocationTimerAsync(true).block(this.maxInitializationTime);
    }

    public UnmodifiableList<RegionalRoutingContext> getReadEndpoints() {
        return this.locationCache.getReadEndpoints();
    }

    public UnmodifiableList<RegionalRoutingContext> getWriteEndpoints() {
        return this.locationCache.getWriteEndpoints();
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableReadRegionalRoutingContexts(RxDocumentServiceRequest request) {
        return this.locationCache.getApplicableReadRegionRoutingContexts(request);
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableWriteRegionalRoutingContexts(RxDocumentServiceRequest request) {
        return this.locationCache.getApplicableWriteRegionRoutingContexts(request);
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableReadRegionalRoutingContexts(List<String> excludedRegions) {
        return this.locationCache.getApplicableReadRegionRoutingContexts(excludedRegions, Collections.emptyList());
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableWriteRegionalRoutingContexts(List<String> excludedRegions) {
        return this.locationCache.getApplicableWriteRegionRoutingContexts(excludedRegions, Collections.emptyList());
    }

    public List<RegionalRoutingContext> getAvailableReadRoutingContexts() {
        return this.locationCache.getAvailableReadRegionalRoutingContexts();
    }

    public List<RegionalRoutingContext> getAvailableWriteRoutingContexts() {
        return this.locationCache.getAvailableWriteRegionalRoutingContexts();
    }

    public static Mono<DatabaseAccount> getDatabaseAccountFromAnyLocationsAsync(URI defaultEndpoint, List<String> locations, Function<URI, Mono<DatabaseAccount>> getDatabaseAccountFn) {
        return getDatabaseAccountFn.apply(defaultEndpoint).onErrorResume(e -> {
            logger.error("Fail to reach global gateway [{}], [{}]", (Object)defaultEndpoint, (Object)e.getMessage());
            if (locations.isEmpty()) {
                return Mono.error((Throwable)e);
            }
            Flux obs = Flux.range((int)0, (int)locations.size()).map(index -> ((Mono)getDatabaseAccountFn.apply(LocationHelper.getLocationEndpoint(defaultEndpoint, (String)locations.get((int)index)))).flux());
            Mono res = Flux.concatDelayError((Publisher)obs).take(1L).single();
            return res.doOnError(innerE -> logger.error("Fail to reach location any of locations {} {}", (Object)String.join((CharSequence)",", locations), (Object)innerE.getMessage()));
        });
    }

    public RegionalRoutingContext resolveServiceEndpoint(RxDocumentServiceRequest request) {
        RegionalRoutingContext serviceEndpoints = this.locationCache.resolveServiceEndpoint(request);
        if (request.faultInjectionRequestContext != null) {
            request.faultInjectionRequestContext.setRegionalRoutingContextToRoute(serviceEndpoints);
        }
        return serviceEndpoints;
    }

    public RegionalRoutingContext resolveFaultInjectionServiceEndpoint(String region, boolean writeOnly) {
        return this.locationCache.resolveFaultInjectionEndpoint(region, writeOnly);
    }

    public URI getDefaultEndpoint() {
        return this.locationCache.getDefaultEndpoint();
    }

    public void markEndpointUnavailableForRead(URI endpoint) {
        logger.debug("Marking endpoint {} unavailable for read", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForRead(endpoint);
    }

    public void markEndpointUnavailableForWrite(URI endpoint) {
        logger.debug("Marking  endpoint {} unavailable for Write", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForWrite(endpoint);
    }

    public boolean canUseMultipleWriteLocations() {
        return this.locationCache.canUseMultipleWriteLocations();
    }

    public boolean canUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.locationCache.canUseMultipleWriteLocations(request);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.scheduler.dispose();
        logger.debug("GlobalEndpointManager closed.");
    }

    public Mono<Void> refreshLocationAsync(DatabaseAccount databaseAccount, boolean forceRefresh) {
        return Mono.defer(() -> {
            logger.debug("refreshLocationAsync() invoked");
            if (forceRefresh) {
                Mono<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.getEffectivePreferredRegions()), this::getDatabaseAccountAsync);
                return databaseAccountObs.map(dbAccount -> {
                    this.databaseAccountWriteLock.lock();
                    try {
                        this.locationCache.onDatabaseAccountRead((DatabaseAccount)dbAccount);
                    }
                    finally {
                        this.databaseAccountWriteLock.unlock();
                    }
                    return dbAccount;
                }).flatMap(dbAccount -> Mono.empty());
            }
            if (!this.isRefreshing.compareAndSet(false, true)) {
                logger.debug("in the middle of another refresh. Not invoking a new refresh.");
                return Mono.empty();
            }
            logger.debug("will refresh");
            return this.refreshLocationPrivateAsync(databaseAccount).doOnError(e -> this.isRefreshing.set(false));
        });
    }

    public DatabaseAccount getLatestDatabaseAccount() {
        return this.latestDatabaseAccount;
    }

    public int getPreferredLocationCount() {
        List<String> effectivePreferredRegions = this.getEffectivePreferredRegions();
        return effectivePreferredRegions != null ? effectivePreferredRegions.size() : 0;
    }

    private Mono<Void> refreshLocationPrivateAsync(DatabaseAccount databaseAccount) {
        return Mono.defer(() -> {
            Utils.ValueHolder<Boolean> canRefreshInBackground;
            logger.debug("refreshLocationPrivateAsync() refreshing locations");
            if (databaseAccount != null) {
                this.databaseAccountWriteLock.lock();
                try {
                    this.locationCache.onDatabaseAccountRead(databaseAccount);
                }
                finally {
                    this.databaseAccountWriteLock.unlock();
                }
            }
            if (this.locationCache.shouldRefreshEndpoints(canRefreshInBackground = new Utils.ValueHolder<Boolean>())) {
                logger.debug("shouldRefreshEndpoints: true");
                if (databaseAccount == null && !((Boolean)canRefreshInBackground.v).booleanValue()) {
                    logger.debug("shouldRefreshEndpoints: can't be done in background");
                    Mono<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.getEffectivePreferredRegions()), this::getDatabaseAccountAsync);
                    return databaseAccountObs.map(dbAccount -> {
                        this.databaseAccountWriteLock.lock();
                        try {
                            this.locationCache.onDatabaseAccountRead((DatabaseAccount)dbAccount);
                        }
                        finally {
                            this.databaseAccountWriteLock.unlock();
                        }
                        this.isRefreshing.set(false);
                        return dbAccount;
                    }).flatMap(dbAccount -> {
                        if (!this.refreshInBackground.get()) {
                            this.startRefreshLocationTimerAsync();
                        }
                        return Mono.empty();
                    });
                }
                if (!this.refreshInBackground.get()) {
                    this.startRefreshLocationTimerAsync();
                }
                this.isRefreshing.set(false);
                return Mono.empty();
            }
            logger.debug("shouldRefreshEndpoints: false, nothing to do.");
            this.isRefreshing.set(false);
            return Mono.empty();
        });
    }

    private void startRefreshLocationTimerAsync() {
        this.startRefreshLocationTimerAsync(false).subscribe();
    }

    private Mono<Void> startRefreshLocationTimerAsync(boolean initialization) {
        if (this.isClosed) {
            logger.debug("startRefreshLocationTimerAsync: nothing to do, it is closed");
            return Mono.empty();
        }
        logger.debug("registering a refresh in [{}] ms", (Object)this.backgroundRefreshLocationTimeIntervalInMS);
        LocalDateTime now = LocalDateTime.now();
        int delayInMillis = initialization ? 0 : this.backgroundRefreshLocationTimeIntervalInMS;
        this.refreshInBackground.set(true);
        return Mono.delay((Duration)Duration.ofMillis(delayInMillis), (Scheduler)CosmosSchedulers.COSMOS_PARALLEL).flatMap(t -> {
            if (this.isClosed) {
                logger.info("client already closed");
                return Mono.empty();
            }
            logger.debug("startRefreshLocationTimerAsync() - Invoking refresh, I was registered on [{}]", (Object)now);
            Mono<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.getEffectivePreferredRegions()), this::getDatabaseAccountAsync);
            return databaseAccountObs.flatMap(dbAccount -> {
                logger.info("db account retrieved {}", dbAccount);
                this.refreshInBackground.set(false);
                return this.refreshLocationPrivateAsync((DatabaseAccount)dbAccount);
            });
        }).onErrorResume(ex -> {
            logger.error("startRefreshLocationTimerAsync() - Unable to refresh database account from any location. Exception: {}", (Object)ex.toString(), ex);
            this.setLatestDatabaseRefreshError((Throwable)ex);
            this.startRefreshLocationTimerAsync();
            return Mono.empty();
        }).subscribeOn(this.scheduler);
    }

    public boolean hasThinClientReadLocations() {
        return this.hasThinClientReadLocations.get();
    }

    private Mono<DatabaseAccount> getDatabaseAccountAsync(URI serviceEndpoint) {
        return this.owner.getDatabaseAccountFromEndpoint(serviceEndpoint).doOnNext(databaseAccount -> {
            if (databaseAccount != null) {
                this.databaseAccountWriteLock.lock();
                try {
                    this.latestDatabaseAccount = databaseAccount;
                    Collection<DatabaseAccountLocation> thinClientReadLocations = databaseAccount.getThinClientReadableLocations();
                    this.hasThinClientReadLocations.set(thinClientReadLocations != null && !thinClientReadLocations.isEmpty());
                    this.setLatestDatabaseRefreshError(null);
                }
                finally {
                    this.databaseAccountWriteLock.unlock();
                }
            }
            logger.debug("account retrieved: {}", databaseAccount);
        }).single();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getRegionName(URI locationEndpoint, OperationType operationType) {
        return this.locationCache.getRegionName(locationEndpoint, operationType);
    }

    public String getRegionName(URI locationEndpoint, OperationType operationType, boolean isPerPartitionAutomaticFailoverEnabledAndWriteRequest) {
        return this.locationCache.getRegionName(locationEndpoint, operationType, isPerPartitionAutomaticFailoverEnabledAndWriteRequest);
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    private List<String> getEffectivePreferredRegions() {
        if (this.connectionPolicy.getPreferredRegions() != null && !this.connectionPolicy.getPreferredRegions().isEmpty()) {
            return this.connectionPolicy.getPreferredRegions();
        }
        this.databaseAccountReadLock.lock();
        try {
            if (this.latestDatabaseAccount == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = this.locationCache.getEffectivePreferredLocations();
            return list;
        }
        finally {
            this.databaseAccountReadLock.unlock();
        }
    }
}

