/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.PartitionIsMigratingException;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.PartitionKeyRangeIsSplittingException;
import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RetryWithException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class GoneAndRetryWithRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(GoneAndRetryWithRetryPolicy.class);
    private final GoneRetryPolicy goneRetryPolicy;
    private final RetryWithRetryPolicy retryWithRetryPolicy;
    private final Instant start;
    private volatile Instant end;
    private volatile RetryWithException lastRetryWithException;
    private RetryContext retryContext;
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();
    private static final ImplementationBridgeHelpers.CosmosExceptionHelper.CosmosExceptionAccessor cosmosExceptionsAccessor = ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor();

    public GoneAndRetryWithRetryPolicy(RxDocumentServiceRequest request, Integer waitTimeInSeconds) {
        this.retryContext = BridgeInternal.getRetryContext(request.requestContext.cosmosDiagnostics);
        this.goneRetryPolicy = new GoneRetryPolicy(request, waitTimeInSeconds, this.retryContext);
        this.retryWithRetryPolicy = new RetryWithRetryPolicy(waitTimeInSeconds, this.retryContext);
        this.start = Instant.now();
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        return this.retryWithRetryPolicy.shouldRetry(exception).flatMap(retryWithResult -> {
            if (!retryWithResult.nonRelatedException) {
                return Mono.just((Object)retryWithResult);
            }
            return this.goneRetryPolicy.shouldRetry(exception).flatMap(goneRetryResult -> {
                if (!goneRetryResult.shouldRetry) {
                    logger.debug("Operation will NOT be retried. Exception:", (Throwable)exception);
                    this.end = Instant.now();
                }
                return Mono.just((Object)goneRetryResult);
            });
        });
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    private Duration getElapsedTime() {
        Instant endSnapshot = this.end != null ? this.end : Instant.now();
        return Duration.between(this.start, endSnapshot);
    }

    class GoneRetryPolicy
    implements IRetryPolicy {
        private static final int DEFAULT_WAIT_TIME_IN_SECONDS = 30;
        private static final int MAXIMUM_BACKOFF_TIME_IN_SECONDS = 15;
        private static final int INITIAL_BACKOFF_TIME = 1;
        private static final int BACK_OFF_MULTIPLIER = 2;
        private final RxDocumentServiceRequest request;
        private final AtomicInteger attemptCount = new AtomicInteger(1);
        private final AtomicInteger attemptCountInvalidPartition = new AtomicInteger(1);
        private final AtomicInteger currentBackoffSeconds = new AtomicInteger(1);
        private final int waitTimeInSeconds;
        private RetryContext retryContext;

        public GoneRetryPolicy(RxDocumentServiceRequest request, Integer waitTimeInSeconds, RetryContext retryContext) {
            Preconditions.checkNotNull(request, "request must not be null.");
            this.request = request;
            this.waitTimeInSeconds = waitTimeInSeconds != null ? waitTimeInSeconds : 30;
            this.retryContext = retryContext;
        }

        private boolean isNonRetryableException(Exception exception) {
            if (exception instanceof GoneException || exception instanceof PartitionIsMigratingException || exception instanceof PartitionKeyRangeIsSplittingException) {
                return false;
            }
            if (exception instanceof InvalidPartitionException) {
                return this.request.getPartitionKeyRangeIdentity() != null && this.request.getPartitionKeyRangeIdentity().getCollectionRid() != null;
            }
            return true;
        }

        private CosmosException logAndWrapExceptionWithLastRetryWithException(Exception exception) {
            String exceptionType;
            if (exception instanceof GoneException) {
                exceptionType = "GoneException";
            } else if (exception instanceof PartitionKeyRangeGoneException) {
                exceptionType = "PartitionKeyRangeGoneException";
            } else if (exception instanceof InvalidPartitionException) {
                exceptionType = "InvalidPartitionException";
            } else if (exception instanceof PartitionKeyRangeIsSplittingException) {
                exceptionType = "PartitionKeyRangeIsSplittingException";
            } else {
                if (exception instanceof CosmosException) {
                    logger.warn("Received CosmosException after backoff/retry. Will fail the request.", (Throwable)exception);
                    return (CosmosException)((Object)exception);
                }
                throw new IllegalStateException("Invalid exception type", exception);
            }
            RetryWithException lastRetryWithExceptionSnapshot = GoneAndRetryWithRetryPolicy.this.lastRetryWithException;
            if (lastRetryWithExceptionSnapshot != null) {
                logger.warn("Received {} after backoff/retry including at least one RetryWithException. Will fail the request with RetryWithException. {}: {}. RetryWithException: {}", new Object[]{exceptionType, exceptionType, exception, lastRetryWithExceptionSnapshot});
                return lastRetryWithExceptionSnapshot;
            }
            logger.warn("Received {} after backoff/retry. Will fail the request. {}", (Object)exceptionType, (Object)exception);
            int subStatusCode = this.getExceptionSubStatusCodeForGoneRetryPolicy(exception);
            return BridgeInternal.createServiceUnavailableException(exception, subStatusCode);
        }

        private int getExceptionSubStatusCodeForGoneRetryPolicy(Exception exception) {
            int exceptionSubStatusCode = 0;
            if (exception instanceof CosmosException) {
                exceptionSubStatusCode = exception instanceof PartitionKeyRangeIsSplittingException ? 21003 : (exception instanceof PartitionIsMigratingException ? 21004 : (exception instanceof InvalidPartitionException ? 21001 : (exception instanceof PartitionKeyRangeGoneException ? 21002 : ((CosmosException)((Object)exception)).getSubStatusCode())));
            }
            return exceptionSubStatusCode;
        }

        @Override
        public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
            long timeoutInMillSec;
            Duration backoffTime = Duration.ofSeconds(0L);
            if (this.isNonRetryableException(exception)) {
                logger.debug("Operation will NOT be retried. Current attempt {}, Exception: ", (Object)this.attemptCount, (Object)exception);
                return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
            }
            if (exception instanceof GoneException && !this.request.isReadOnly() && BridgeInternal.hasSendingRequestStarted((CosmosException)((Object)exception)) && !((GoneException)((Object)exception)).isBasedOn410ResponseFromService() && !this.request.getNonIdempotentWriteRetriesEnabled()) {
                logger.warn("Operation will NOT be retried. Write operations which failed due to transient transport errors can not be retried safely when sending the request to the service because they aren't idempotent. Current attempt {}, Exception: ", (Object)this.attemptCount, (Object)exception);
                CosmosException exceptionToThrow = cosmosExceptionsAccessor.createCosmosException(408, exception);
                GoneException goneException = Utils.as(exception, GoneException.class);
                BridgeInternal.setSubStatusCode(exceptionToThrow, goneException.getSubStatusCode());
                return Mono.just((Object)ShouldRetryResult.noRetry((Exception)((Object)exceptionToThrow), Quadruple.with(true, true, Duration.ofMillis(0L), this.attemptCount.get())));
            }
            long remainingSeconds = (long)this.waitTimeInSeconds - GoneAndRetryWithRetryPolicy.this.getElapsedTime().toMillis() / 1000L;
            int currentRetryAttemptCount = this.attemptCount.get();
            if (this.attemptCount.getAndIncrement() > 1) {
                if (remainingSeconds <= 0L) {
                    CosmosException exceptionToThrow = this.logAndWrapExceptionWithLastRetryWithException(exception);
                    return Mono.just((Object)ShouldRetryResult.error((Exception)((Object)exceptionToThrow)));
                }
                backoffTime = Duration.ofSeconds(Math.min(Math.min((long)this.currentBackoffSeconds.get(), remainingSeconds), 15L));
                this.currentBackoffSeconds.accumulateAndGet(2, (left, right) -> left * right);
                logger.debug("BackoffTime: {} seconds.", (Object)backoffTime.getSeconds());
            }
            Duration timeout = (timeoutInMillSec = remainingSeconds * 1000L - backoffTime.toMillis()) > 0L ? Duration.ofMillis(timeoutInMillSec) : Duration.ofSeconds(15L);
            logger.debug("Timeout. {} - BackoffTime {} - currentBackoffSeconds {} - CurrentRetryAttemptCount {}", new Object[]{timeout.toMillis(), backoffTime, this.currentBackoffSeconds, currentRetryAttemptCount});
            Pair<Mono<ShouldRetryResult>, Boolean> exceptionHandlingResult = this.handleException(exception);
            Mono<ShouldRetryResult> result = exceptionHandlingResult.getLeft();
            if (result != null) {
                return result;
            }
            boolean forceRefreshAddressCache = exceptionHandlingResult.getRight();
            return Mono.just((Object)ShouldRetryResult.retryAfter(backoffTime, Quadruple.with(forceRefreshAddressCache, true, timeout, currentRetryAttemptCount)));
        }

        @Override
        public RetryContext getRetryContext() {
            return this.retryContext;
        }

        private Pair<Mono<ShouldRetryResult>, Boolean> handleException(Exception exception) {
            if (exception instanceof GoneException) {
                return this.handleGoneException((GoneException)((Object)exception));
            }
            if (exception instanceof PartitionIsMigratingException) {
                return this.handlePartitionIsMigratingException((PartitionIsMigratingException)((Object)exception));
            }
            if (exception instanceof InvalidPartitionException) {
                return this.handleInvalidPartitionException((InvalidPartitionException)((Object)exception));
            }
            if (exception instanceof PartitionKeyRangeIsSplittingException) {
                return this.handlePartitionKeyIsSplittingException((PartitionKeyRangeIsSplittingException)((Object)exception));
            }
            throw new IllegalStateException("Invalid exception type", exception);
        }

        private Pair<Mono<ShouldRetryResult>, Boolean> handleGoneException(GoneException exception) {
            logger.debug("Received gone exception, will retry, {}", (Object)exception.toString());
            return Pair.of(null, true);
        }

        private Pair<Mono<ShouldRetryResult>, Boolean> handlePartitionIsMigratingException(PartitionIsMigratingException exception) {
            logger.debug("Received PartitionIsMigratingException, will retry, {}", (Object)exception.toString());
            this.request.forceCollectionRoutingMapRefresh = true;
            return Pair.of(null, true);
        }

        private Pair<Mono<ShouldRetryResult>, Boolean> handlePartitionKeyIsSplittingException(PartitionKeyRangeIsSplittingException exception) {
            this.request.requestContext.resolvedPartitionKeyRange = null;
            this.request.requestContext.quorumSelectedLSN = -1L;
            this.request.requestContext.quorumSelectedStoreResponse = null;
            logger.debug("Received partition key range splitting exception, will retry, {}", (Object)exception.toString());
            this.request.forcePartitionKeyRangeRefresh = true;
            return Pair.of(null, false);
        }

        private Pair<Mono<ShouldRetryResult>, Boolean> handleInvalidPartitionException(InvalidPartitionException exception) {
            this.request.requestContext.quorumSelectedLSN = -1L;
            this.request.requestContext.resolvedPartitionKeyRange = null;
            this.request.requestContext.quorumSelectedStoreResponse = null;
            this.request.requestContext.globalCommittedSelectedLSN = -1L;
            if (this.attemptCountInvalidPartition.getAndIncrement() > 2) {
                logger.warn("Received second InvalidPartitionException after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                return Pair.of(Mono.just((Object)ShouldRetryResult.error((Exception)((Object)BridgeInternal.createServiceUnavailableException((Exception)((Object)exception), 21001)))), false);
            }
            logger.debug("Received invalid collection exception, will retry, {}", (Object)exception.toString());
            this.request.forceNameCacheRefresh = true;
            return Pair.of(null, false);
        }
    }

    class RetryWithRetryPolicy
    implements IRetryPolicy {
        private static final int DEFAULT_WAIT_TIME_IN_SECONDS = 30;
        private static final int MAXIMUM_BACKOFF_TIME_IN_MS = 1000;
        private static final int INITIAL_BACKOFF_TIME_MS = 10;
        private static final int BACK_OFF_MULTIPLIER = 2;
        private static final int RANDOM_SALT_IN_MS = 5;
        private final AtomicInteger attemptCount = new AtomicInteger(1);
        private final AtomicInteger currentBackoffMilliseconds = new AtomicInteger(10);
        private final int waitTimeInSeconds;
        private final RetryContext retryContext;

        public RetryWithRetryPolicy(Integer waitTimeInSeconds, RetryContext retryContext) {
            this.waitTimeInSeconds = waitTimeInSeconds != null ? waitTimeInSeconds : 30;
            this.retryContext = retryContext;
        }

        @Override
        public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
            if (!(exception instanceof RetryWithException)) {
                logger.debug("Operation will NOT be retried. Current attempt {}, Exception: ", (Object)this.attemptCount.get(), (Object)exception);
                return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
            }
            RetryWithException lastRetryWithException = (RetryWithException)((Object)exception);
            GoneAndRetryWithRetryPolicy.this.lastRetryWithException = lastRetryWithException;
            long remainingMilliseconds = (long)this.waitTimeInSeconds * 1000L - GoneAndRetryWithRetryPolicy.this.getElapsedTime().toMillis();
            int currentRetryAttemptCount = this.attemptCount.getAndIncrement();
            if (remainingMilliseconds <= 0L) {
                logger.warn("Received RetryWithException after backoff/retry. Will fail the request.", (Throwable)((Object)lastRetryWithException));
                return Mono.just((Object)ShouldRetryResult.error((Exception)((Object)lastRetryWithException)));
            }
            Duration backoffTime = Duration.ofMillis(Math.min(Math.min((long)(this.currentBackoffMilliseconds.get() + random.nextInt(5)), remainingMilliseconds), 1000L));
            this.currentBackoffMilliseconds.set(Math.max(10, Math.min(1000, this.currentBackoffMilliseconds.get() * 2)));
            logger.debug("BackoffTime: {} ms.", (Object)backoffTime.toMillis());
            long timeoutInMillSec = remainingMilliseconds - backoffTime.toMillis();
            Duration timeout = timeoutInMillSec > 0L ? Duration.ofMillis(timeoutInMillSec) : Duration.ofMillis(1000L);
            logger.debug("Received RetryWithException, will retry, ", (Throwable)exception);
            return Mono.just((Object)ShouldRetryResult.retryAfter(backoffTime, Quadruple.with(false, true, timeout, currentRetryAttemptCount)));
        }

        @Override
        public RetryContext getRetryContext() {
            return this.retryContext;
        }
    }
}

