/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion.feedRangeGoneHandler;

import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.epkversion.feedRangeGoneHandler.FeedRangeGoneHandler;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class FeedRangeGoneMergeHandler
implements FeedRangeGoneHandler {
    private static final Logger logger = LoggerFactory.getLogger(FeedRangeGoneMergeHandler.class);
    private final Lease lease;
    private final PartitionKeyRange overlappingRange;
    private final AtomicBoolean removeCurrentLease;

    public FeedRangeGoneMergeHandler(Lease lease, PartitionKeyRange overlappingRange) {
        Preconditions.checkNotNull(lease, "Argument 'lease' can not be null");
        Preconditions.checkNotNull(overlappingRange, "Argument 'overlappingRange' can not be null");
        this.lease = lease;
        this.overlappingRange = overlappingRange;
        this.removeCurrentLease = new AtomicBoolean();
    }

    @Override
    public Flux<Lease> handlePartitionGone() {
        this.removeCurrentLease.set(false);
        logger.info("Lease {} redirected to {}", (Object)this.lease.getLeaseToken(), (Object)this.overlappingRange.getId());
        return Flux.just((Object)this.lease);
    }

    @Override
    public boolean shouldDeleteCurrentLease() {
        return this.removeCurrentLease.get();
    }

    @Override
    public boolean shouldSkipDirectLeaseAssignment() {
        return false;
    }
}

