/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import java.util.LinkedHashMap;
import java.util.Map;

public class SizeLimitingLRUCache
extends LinkedHashMap<String, PartitionedQueryExecutionInfo> {
    private static final long serialVersionUID = 1L;
    private final int maxEntries;

    public SizeLimitingLRUCache(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public SizeLimitingLRUCache(int initialCapacity, float loadFactor, int maxEntries) {
        super(initialCapacity, loadFactor);
        this.maxEntries = maxEntries;
    }

    public SizeLimitingLRUCache(Map<? extends String, ? extends PartitionedQueryExecutionInfo> m, int maxEntries) {
        super(m);
        this.maxEntries = maxEntries;
    }

    public SizeLimitingLRUCache(int initialCapacity, float loadFactor, boolean accessOrder, int maxEntries) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxEntries = maxEntries;
    }

    public SizeLimitingLRUCache(int initialCapacity, int maxEntries) {
        super(initialCapacity);
        this.maxEntries = maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, PartitionedQueryExecutionInfo> eldest) {
        return this.size() > this.maxEntries;
    }
}

