/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.text.MessageFormat;

class SqlVarbinarySerializer
extends SqlSerializer {
    private int max = -1;
    private int defaultSize = 30;
    private int minSize = 1;
    private int maxSize = 8000;

    public SqlVarbinarySerializer(int size, int precision, int scale) throws MicrosoftDataEncryptionException {
        this.size = size == 0 ? this.defaultSize : size;
        if (size != this.max && (this.size < this.minSize || this.size > this.maxSize)) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_parameterOutOfRange"));
            Object[] msgArgs = new Object[]{"size"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return SqlSerializerUtil.normalizedValue(JDBCType.VARBINARY, value, this.size, this.scale);
        }
        return null;
    }

    @Override
    public byte[] deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (byte[])SqlSerializerUtil.denormalizedValue(bytes, JDBCType.VARBINARY, SSType.VARBINARY, this.size, this.scale, null);
    }
}

