/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.sql.Time;
import java.sql.Timestamp;

class SqlTimeSerializer
extends SqlSerializer {
    public SqlTimeSerializer(int size, int precision, int scale) {
        this.size = size;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            if (value instanceof Time) {
                String time = "1900-01-01 " + value.toString();
                Timestamp ts = Timestamp.valueOf(time);
                return SqlSerializerUtil.normalizedValue(JDBCType.TIME, ts, this.precision, this.scale);
            }
            return SqlSerializerUtil.normalizedValue(JDBCType.TIME, value, this.precision, this.scale);
        }
        return null;
    }

    @Override
    public Time deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (Time)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.TIME, SSType.TIME, this.precision, this.scale, null);
    }
}

