/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.text.MessageFormat;

class SqlNvarcharSerializer
extends SqlSerializer {
    private int max = -1;
    private int defaultSize = 30;
    private int minSize = 1;
    private int maxSize = 4000;
    private String customCodepage = null;

    public SqlNvarcharSerializer(int size, int precision, int scale) throws MicrosoftDataEncryptionException {
        this.size = size == 0 ? this.defaultSize : size;
        if (size != this.max && (this.size < this.minSize || this.size > this.maxSize)) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_parameterOutOfRange"));
            Object[] msgArgs = new Object[]{"size"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return null == this.customCodepage ? SqlSerializerUtil.normalizedValue(JDBCType.NVARCHAR, value, this.size, this.scale) : SqlSerializerUtil.normalizedValue(JDBCType.NVARCHAR, value, this.size, this.scale, this.customCodepage);
        }
        return null;
    }

    @Override
    public String deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return null == this.customCodepage ? (String)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.NVARCHAR, SSType.NVARCHAR, this.size, this.scale, null) : (String)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.NVARCHAR, SSType.NVARCHAR, this.size, this.scale, null, this.customCodepage);
    }

    public void setCodepage(String codepage) {
        this.customCodepage = codepage;
    }
}

