/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;

class SqlNumericSerializer
extends SqlSerializer {
    private int defaultPrecision = 18;
    private int minPrecision = 1;
    private int maxPrecision = 38;
    private int minScale = 0;

    public SqlNumericSerializer(int size, int precision, int scale) throws MicrosoftDataEncryptionException {
        this.precision = precision == 0 ? this.defaultPrecision : precision;
        if (this.precision < this.minPrecision || this.precision > this.maxPrecision) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_parameterOutOfRange"));
            Object[] msgArgs = new Object[]{"precision"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        if (scale < this.minScale || scale > precision) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_parameterOutOfRange"));
            Object[] msgArgs = new Object[]{"scale"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        this.size = size;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return SqlSerializerUtil.normalizedValue(JDBCType.NUMERIC, value, this.precision, this.scale);
        }
        return null;
    }

    @Override
    public BigDecimal deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (BigDecimal)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.NUMERIC, SSType.NUMERIC, this.precision, this.scale, null);
    }
}

