/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DateTimeOffset;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;

enum JDBCType {
    UNKNOWN(Category.UNKNOWN, 999, Object.class.getName()),
    ARRAY(Category.UNKNOWN, 2003, Object.class.getName()),
    BIGINT(Category.NUMERIC, -5, Long.class.getName()),
    BINARY(Category.BINARY, -2, "[B"),
    BIT(Category.NUMERIC, -7, Boolean.class.getName()),
    BLOB(Category.BLOB, 2004, Blob.class.getName()),
    BOOLEAN(Category.NUMERIC, 16, Boolean.class.getName()),
    CHAR(Category.CHARACTER, 1, String.class.getName()),
    CLOB(Category.CLOB, 2005, Clob.class.getName()),
    DATALINK(Category.UNKNOWN, 70, Object.class.getName()),
    DATE(Category.DATE, 91, Date.class.getName()),
    DATETIMEOFFSET(Category.DATETIMEOFFSET, -155, DateTimeOffset.class.getName()),
    DECIMAL(Category.NUMERIC, 3, BigDecimal.class.getName()),
    DISTINCT(Category.UNKNOWN, 2001, Object.class.getName()),
    DOUBLE(Category.NUMERIC, 8, Double.class.getName()),
    FLOAT(Category.NUMERIC, 6, Double.class.getName()),
    INTEGER(Category.NUMERIC, 4, Integer.class.getName()),
    JAVA_OBJECT(Category.UNKNOWN, 2000, Object.class.getName()),
    LONGNVARCHAR(Category.LONG_NCHARACTER, -16, String.class.getName()),
    LONGVARBINARY(Category.LONG_BINARY, -4, "[B"),
    LONGVARCHAR(Category.LONG_CHARACTER, -1, String.class.getName()),
    NCHAR(Category.NCHARACTER, -15, String.class.getName()),
    NCLOB(Category.NCLOB, 2011, NClob.class.getName()),
    NULL(Category.UNKNOWN, 0, Object.class.getName()),
    NUMERIC(Category.NUMERIC, 2, BigDecimal.class.getName()),
    NVARCHAR(Category.NCHARACTER, -9, String.class.getName()),
    OTHER(Category.UNKNOWN, 1111, Object.class.getName()),
    REAL(Category.NUMERIC, 7, Float.class.getName()),
    REF(Category.UNKNOWN, 2006, Object.class.getName()),
    ROWID(Category.UNKNOWN, -8, Object.class.getName()),
    SMALLINT(Category.NUMERIC, 5, Short.class.getName()),
    SQLXML(Category.SQLXML, 2009, Object.class.getName()),
    STRUCT(Category.UNKNOWN, 2002, Object.class.getName()),
    TIME(Category.TIME, 92, Time.class.getName()),
    TIME_WITH_TIMEZONE(Category.TIME_WITH_TIMEZONE, 2013, OffsetTime.class.getName()),
    TIMESTAMP(Category.TIMESTAMP, 93, Timestamp.class.getName()),
    TIMESTAMP_WITH_TIMEZONE(Category.TIMESTAMP_WITH_TIMEZONE, 2014, OffsetDateTime.class.getName()),
    TINYINT(Category.NUMERIC, -6, Short.class.getName()),
    VARBINARY(Category.BINARY, -3, "[B"),
    VARCHAR(Category.CHARACTER, 12, String.class.getName()),
    MONEY(Category.NUMERIC, -148, BigDecimal.class.getName()),
    SMALLMONEY(Category.NUMERIC, -146, BigDecimal.class.getName()),
    TVP(Category.TVP, -153, Object.class.getName()),
    DATETIME(Category.TIMESTAMP, -151, Timestamp.class.getName()),
    SMALLDATETIME(Category.TIMESTAMP, -150, Timestamp.class.getName()),
    GUID(Category.CHARACTER, -145, String.class.getName()),
    SQL_VARIANT(Category.SQL_VARIANT, -156, Object.class.getName()),
    GEOMETRY(Category.GEOMETRY, -157, Object.class.getName()),
    GEOGRAPHY(Category.GEOGRAPHY, -158, Object.class.getName()),
    LOCALDATETIME(Category.TIMESTAMP, 93, LocalDateTime.class.getName());

    final Category category;
    private final int intValue;
    private final String className;
    private static final JDBCType[] VALUES;

    final String className() {
        return this.className;
    }

    private JDBCType(Category category, int intValue, String className) {
        this.category = category;
        this.intValue = intValue;
        this.className = className;
    }

    public int getIntValue() {
        return this.intValue;
    }

    static {
        VALUES = JDBCType.values();
    }

    static enum Category {
        CHARACTER,
        LONG_CHARACTER,
        CLOB,
        NCHARACTER,
        LONG_NCHARACTER,
        NCLOB,
        BINARY,
        LONG_BINARY,
        BLOB,
        NUMERIC,
        DATE,
        TIME,
        TIMESTAMP,
        TIME_WITH_TIMEZONE,
        TIMESTAMP_WITH_TIMEZONE,
        DATETIMEOFFSET,
        SQLXML,
        UNKNOWN,
        TVP,
        GUID,
        SQL_VARIANT,
        GEOMETRY,
        GEOGRAPHY;

        private static final Category[] VALUES;

        static {
            VALUES = Category.values();
        }
    }
}

