/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

class GregorianChange {
    static final int DAYS_PER_YEAR = 365;
    static final Date PURE_CHANGE_DATE = new Date(Long.MIN_VALUE);
    static final Date STANDARD_CHANGE_DATE = new GregorianCalendar(Locale.US).getGregorianChange();
    static final int DAYS_SINCE_BASE_DATE_HINT = GregorianChange.daysSinceBaseDate(1583, 1, 1);
    static final int EXTRA_DAYS_TO_BE_ADDED;

    GregorianChange() {
    }

    static int daysSinceBaseDate(int year, int dayOfYear, int baseYear) {
        assert (year >= 1);
        assert (baseYear >= 1);
        assert (dayOfYear >= 1);
        return dayOfYear - 1 + (year - baseYear) * 365 + GregorianChange.leapDaysBeforeYear(year) - GregorianChange.leapDaysBeforeYear(baseYear);
    }

    private static int leapDaysBeforeYear(int year) {
        assert (year >= 1);
        return (year - 1) / 4 - (year - 1) / 100 + (year - 1) / 400;
    }

    static {
        GregorianCalendar cal = new GregorianCalendar(Locale.US);
        cal.clear();
        cal.set(1, 1, 577738, 0, 0, 0);
        EXTRA_DAYS_TO_BE_ADDED = cal.get(5) == 15 ? 2 : 0;
    }
}

