/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.CryptographyExtensions;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataProtector;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SecurityUtility;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Tuple;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AeadAes256CbcHmac256EncryptionAlgorithm
extends DataProtector {
    static final String algorithmName = "AEAD_AES_256_CBC_HMAC_SHA256";
    private DataEncryptionKey columnEncryptionkey;
    private byte algorithmVersion = 1;
    private boolean isDeterministic = false;
    private int blockSizeInBytes = 16;
    private int keySizeInBits = 256;
    private int keySizeInBytes = this.keySizeInBits / 8;
    private byte[] version = new byte[]{1};
    private byte[] versionSize = new byte[]{1};
    private int minimumCipherTextLengthInBytesNoAuthenticationTag = 1 + this.blockSizeInBytes + this.blockSizeInBytes;
    private int minimumCipherTextLengthInBytesWithAuthenticationTag = this.minimumCipherTextLengthInBytesNoAuthenticationTag + this.keySizeInBytes;
    private static Map<Tuple<DataEncryptionKey, EncryptionType>, AeadAes256CbcHmac256EncryptionAlgorithm> algorithmCache = new ConcurrentHashMap<Tuple<DataEncryptionKey, EncryptionType>, AeadAes256CbcHmac256EncryptionAlgorithm>();

    public static AeadAes256CbcHmac256EncryptionAlgorithm getOrCreate(DataEncryptionKey dataEncryptionKey, EncryptionType encryptionType) throws MicrosoftDataEncryptionException {
        if (null == dataEncryptionKey) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullColumnEncryptionKey"));
        }
        Tuple<DataEncryptionKey, EncryptionType> key = new Tuple<DataEncryptionKey, EncryptionType>(dataEncryptionKey, encryptionType);
        if (algorithmCache.containsKey(key)) {
            return algorithmCache.get(key);
        }
        AeadAes256CbcHmac256EncryptionAlgorithm e = new AeadAes256CbcHmac256EncryptionAlgorithm(dataEncryptionKey, encryptionType);
        algorithmCache.put(key, e);
        return e;
    }

    public AeadAes256CbcHmac256EncryptionAlgorithm(DataEncryptionKey dataEncryptionKey, EncryptionType encryptionType) throws MicrosoftDataEncryptionException {
        this.validateEncryptionKeySize(dataEncryptionKey.getRootKeyBytes().length);
        this.columnEncryptionkey = dataEncryptionKey;
        if (encryptionType == EncryptionType.Deterministic) {
            this.isDeterministic = true;
        }
    }

    private void validateEncryptionKeySize(int size) throws MicrosoftDataEncryptionException {
        if (size != this.keySizeInBytes) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataEncryptionKeySize"));
            Object[] msgArgs = new Object[]{size};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws MicrosoftDataEncryptionException {
        return this.encryptData(plaintext, true);
    }

    protected byte[] encryptData(byte[] plainText, boolean hasAuthenticationTag) throws MicrosoftDataEncryptionException {
        assert (plainText != null);
        byte[] iv = new byte[this.blockSizeInBytes];
        SecretKeySpec skeySpec = new SecretKeySpec(this.columnEncryptionkey.getEncryptionKeyBytes(), "AES");
        if (this.isDeterministic) {
            try {
                iv = SecurityUtility.getHMACWithSHA256(plainText, this.columnEncryptionkey.getIvKeyBytes(), this.blockSizeInBytes);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_EncryptionFailed"));
                byte[] slice = Arrays.copyOfRange(this.columnEncryptionkey.getEncryptionKeyBytes(), this.columnEncryptionkey.getEncryptionKeyBytes().length - 10, this.columnEncryptionkey.getEncryptionKeyBytes().length);
                Object[] msgArgs = new Object[]{CryptographyExtensions.toHexStringWithDashes(slice)};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        } else {
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
        }
        int numBlocks = plainText.length / this.blockSizeInBytes + 1;
        int hmacStartIndex = 1;
        int authenticationTagLen = hasAuthenticationTag ? this.keySizeInBytes : 0;
        int ivStartIndex = hmacStartIndex + authenticationTagLen;
        int cipherStartIndex = ivStartIndex + this.blockSizeInBytes;
        int outputBufSize = 1 + authenticationTagLen + iv.length + numBlocks * this.blockSizeInBytes;
        byte[] outBuffer = new byte[outputBufSize];
        outBuffer[0] = this.algorithmVersion;
        System.arraycopy(iv, 0, outBuffer, ivStartIndex, iv.length);
        try {
            IvParameterSpec ivector = new IvParameterSpec(iv);
            Cipher encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            encryptCipher.init(1, (Key)skeySpec, ivector);
            int count = 0;
            int cipherIndex = cipherStartIndex;
            if (numBlocks > 1) {
                count = (numBlocks - 1) * this.blockSizeInBytes;
                cipherIndex += encryptCipher.update(plainText, 0, count, outBuffer, cipherIndex);
            }
            byte[] buffTmp = encryptCipher.doFinal(plainText, count, plainText.length - count);
            System.arraycopy(buffTmp, 0, outBuffer, cipherIndex, buffTmp.length);
            if (hasAuthenticationTag) {
                Mac hmac = Mac.getInstance("HmacSHA256");
                SecretKeySpec initkey = new SecretKeySpec(this.columnEncryptionkey.getMacKeyBytes(), "HmacSHA256");
                hmac.init(initkey);
                hmac.update(this.version, 0, this.version.length);
                hmac.update(iv, 0, iv.length);
                hmac.update(outBuffer, cipherStartIndex, numBlocks * this.blockSizeInBytes);
                hmac.update(this.versionSize, 0, this.version.length);
                byte[] hash = hmac.doFinal();
                System.arraycopy(hash, 0, outBuffer, hmacStartIndex, authenticationTagLen);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_EncryptionFailed"));
            byte[] slice = Arrays.copyOfRange(this.columnEncryptionkey.getEncryptionKeyBytes(), this.columnEncryptionkey.getEncryptionKeyBytes().length - 10, this.columnEncryptionkey.getEncryptionKeyBytes().length);
            Object[] msgArgs = new Object[]{CryptographyExtensions.toHexStringWithDashes(slice)};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        return outBuffer;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws MicrosoftDataEncryptionException {
        return this.decryptData(ciphertext, true);
    }

    private byte[] decryptData(byte[] cipherText, boolean hasAuthenticationTag) throws MicrosoftDataEncryptionException {
        int minimumCipherTextLength;
        assert (cipherText != null);
        byte[] iv = new byte[this.blockSizeInBytes];
        int n = minimumCipherTextLength = hasAuthenticationTag ? this.minimumCipherTextLengthInBytesWithAuthenticationTag : this.minimumCipherTextLengthInBytesNoAuthenticationTag;
        if (cipherText.length < minimumCipherTextLength) {
            throw new MicrosoftDataEncryptionException();
        }
        int startIndex = 0;
        if (cipherText[startIndex] != this.algorithmVersion) {
            throw new MicrosoftDataEncryptionException();
        }
        ++startIndex;
        int authenticationTagOffset = 0;
        if (hasAuthenticationTag) {
            authenticationTagOffset = startIndex;
            startIndex += this.keySizeInBytes;
        }
        System.arraycopy(cipherText, startIndex, iv, 0, iv.length);
        int cipherTextOffset = startIndex += iv.length;
        int cipherTextCount = cipherText.length - startIndex;
        if (hasAuthenticationTag) {
            byte[] authenticationTag;
            try {
                authenticationTag = this.prepareAuthenticationTag(iv, cipherText, cipherTextOffset, cipherTextCount);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidCipherTextSize"));
                Object[] msgArgs = new Object[]{cipherText.length, minimumCipherTextLength};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
            if (!SecurityUtility.compareBytes(authenticationTag, cipherText, authenticationTagOffset, cipherTextCount)) {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidAlgorithmVersion"));
                Object[] msgArgs = new Object[]{String.format("%02X ", cipherText[startIndex]), String.format("%02X ", new Object[0])};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        return this.decryptData(iv, cipherText, cipherTextOffset, cipherTextCount);
    }

    private byte[] decryptData(byte[] iv, byte[] cipherText, int offset, int count) throws MicrosoftDataEncryptionException {
        assert (cipherText != null);
        assert (iv != null);
        byte[] plainText = null;
        SecretKeySpec skeySpec = new SecretKeySpec(this.columnEncryptionkey.getEncryptionKeyBytes(), "AES");
        IvParameterSpec ivector = new IvParameterSpec(iv);
        try {
            Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            decryptCipher.init(2, (Key)skeySpec, ivector);
            plainText = decryptCipher.doFinal(cipherText, offset, count);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            byte[] sliceDEK = Arrays.copyOfRange(this.columnEncryptionkey.getEncryptionKeyBytes(), this.columnEncryptionkey.getEncryptionKeyBytes().length - 10, this.columnEncryptionkey.getEncryptionKeyBytes().length);
            byte[] sliceCipher = Arrays.copyOfRange(cipherText, cipherText.length - 10, cipherText.length);
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_DecryptionFailed"));
            Object[] msgArgs = new Object[]{CryptographyExtensions.toHexStringWithDashes(sliceDEK), CryptographyExtensions.toHexStringWithDashes(sliceCipher)};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        return plainText;
    }

    private byte[] prepareAuthenticationTag(byte[] iv, byte[] cipherText, int offset, int length) throws NoSuchAlgorithmException, InvalidKeyException {
        assert (cipherText != null);
        byte[] authenticationTag = new byte[this.keySizeInBytes];
        Mac hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec key = new SecretKeySpec(this.columnEncryptionkey.getMacKeyBytes(), "HmacSHA256");
        hmac.init(key);
        hmac.update(this.version, 0, this.version.length);
        hmac.update(iv, 0, iv.length);
        hmac.update(cipherText, offset, length);
        hmac.update(this.versionSize, 0, this.version.length);
        byte[] computedHash = hmac.doFinal();
        System.arraycopy(computedHash, 0, authenticationTag, 0, authenticationTag.length);
        return authenticationTag;
    }
}

