// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.azure.core.http;

/**
 * The HTTP request methods.
 */
public enum HttpMethod {
    /**
     * The HTTP GET method.
     */
    GET,

    /**
     * The HTTP PUT method.
     */
    PUT,

    /**
     * The HTTP POST method.
     */
    POST,

    /**
     * The HTTP PATCH method.
     */
    PATCH,

    /**
     * The HTTP DELETE method.
     */
    DELETE,

    /**
     * The HTTP HEAD method.
     */
    HEAD,

    /**
     * The HTTP OPTIONS method.
     */
    OPTIONS,

    /**
     * The HTTP TRACE method.
     */
    TRACE,

    /**
     * The HTTP CONNECT method.
     */
    CONNECT
}
