/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.annotation.SyncAsyncTest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import reactor.core.publisher.Mono;

public final class SyncAsyncExtension
implements TestTemplateInvocationContextProvider {
    private static final ThreadLocal<Boolean> IS_SYNC_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Boolean> WAS_EXTENSION_USED_THREAD_LOCAL = new ThreadLocal();

    public static <T> T execute(Callable<T> sync, Callable<Mono<T>> async) {
        Boolean isSync = IS_SYNC_THREAD_LOCAL.get();
        WAS_EXTENSION_USED_THREAD_LOCAL.set(true);
        if (isSync == null) {
            throw new IllegalStateException("The IS_SYNC_THREAD_LOCAL is undefined. Make sure you're using@SyncAsyncTest with SyncAsyncExtension.execute()");
        }
        try {
            if (isSync.booleanValue()) {
                return sync.call();
            }
            return (T)async.call().block();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void execute(Runnable sync, Callable<Mono<Void>> async) {
        Boolean isSync = IS_SYNC_THREAD_LOCAL.get();
        WAS_EXTENSION_USED_THREAD_LOCAL.set(true);
        if (isSync == null) {
            throw new IllegalStateException("The IS_SYNC_THREAD_LOCAL is undefined. Make sure you're using@SyncAsyncTest with SyncAsyncExtension.execute()");
        }
        try {
            if (isSync.booleanValue()) {
                sync.run();
            } else {
                async.call().block();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return extensionContext.getTestMethod().map(method -> method.getAnnotation(SyncAsyncTest.class) != null).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return Stream.of(new SyncAsyncTestTemplateInvocationContext(true), new SyncAsyncTestTemplateInvocationContext(false));
    }

    private static final class SyncAsyncTestTemplateInvocationContext
    implements TestTemplateInvocationContext {
        private final boolean isSync;

        private SyncAsyncTestTemplateInvocationContext(boolean isSync) {
            this.isSync = isSync;
        }

        public String getDisplayName(int invocationIndex) {
            return this.isSync ? "sync" : "async";
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new SyncAsyncTestInterceptor(this.isSync));
        }
    }

    private static final class SyncAsyncTestInterceptor
    implements BeforeTestExecutionCallback,
    AfterTestExecutionCallback {
        private final boolean isSync;

        private SyncAsyncTestInterceptor(boolean isSync) {
            this.isSync = isSync;
        }

        public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
            if (IS_SYNC_THREAD_LOCAL.get() != null) {
                throw new IllegalStateException("The IS_SYNC_THREAD_LOCAL shouldn't be set at this point");
            }
            if (WAS_EXTENSION_USED_THREAD_LOCAL.get() != null) {
                throw new IllegalStateException("The WAS_EXTENSION_USED_THREAD_LOCAL shouldn't be set at this point");
            }
            IS_SYNC_THREAD_LOCAL.set(this.isSync);
            WAS_EXTENSION_USED_THREAD_LOCAL.set(false);
        }

        public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
            IS_SYNC_THREAD_LOCAL.remove();
            if (!((Boolean)WAS_EXTENSION_USED_THREAD_LOCAL.get()).booleanValue()) {
                throw new IllegalStateException("You should use SyncAsyncExtension.execute() in test annotated with @SyncAsyncTest");
            }
            WAS_EXTENSION_USED_THREAD_LOCAL.remove();
        }
    }
}

