/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.test.TestMode;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.utils.ResourceNamer;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class TestResourceNamer
extends ResourceNamer {
    private final TestMode testMode;
    private final RecordedData recordedData;

    public TestResourceNamer(String name, TestMode testMode, RecordedData recordedData) {
        super(name);
        Objects.requireNonNull(recordedData, "'recordedData' cannot be null.");
        this.recordedData = recordedData;
        this.testMode = testMode;
    }

    @Override
    public String randomName(String prefix, int maxLen) {
        if (this.testMode == TestMode.PLAYBACK) {
            return this.recordedData.removeVariable();
        }
        String name = super.randomName(prefix, maxLen);
        this.recordedData.addVariable(name);
        return name;
    }

    @Override
    public String randomUuid() {
        if (this.testMode == TestMode.PLAYBACK) {
            return this.recordedData.removeVariable();
        }
        String uuid = super.randomUuid();
        this.recordedData.addVariable(uuid);
        return uuid;
    }

    public OffsetDateTime now() {
        if (this.testMode == TestMode.PLAYBACK) {
            return OffsetDateTime.parse(this.recordedData.removeVariable());
        }
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        this.recordedData.addVariable(now.toString());
        return now;
    }

    public String recordValueFromConfig(String value) {
        if (this.testMode == TestMode.PLAYBACK) {
            return this.recordedData.removeVariable();
        }
        this.recordedData.addVariable(value);
        return value;
    }
}

