/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.implementation.AccessControllerUtils;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class HeaderCollectionHandler {
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Field, ReflectiveInvoker> FIELD_TO_SETTER_INVOKER_CACHE = new ConcurrentHashMap<Field, ReflectiveInvoker>();
    private static final ReflectiveInvoker NO_SETTER_REFLECTIVE_INVOKER = ReflectionUtils.createNoOpInvoker();
    private final String prefix;
    private final int prefixLength;
    private final Map<String, String> values;
    private final Field declaringField;

    HeaderCollectionHandler(String prefix, Field declaringField) {
        this.prefix = prefix;
        this.prefixLength = prefix.length();
        this.values = new HashMap<String, String>();
        this.declaringField = declaringField;
    }

    boolean headerStartsWithPrefix(String headerName) {
        return headerName.startsWith(this.prefix);
    }

    void addHeader(String headerName, String headerValue) {
        this.values.put(headerName.substring(this.prefixLength), headerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectValuesIntoDeclaringField(Object deserializedHeaders, ClientLogger logger) {
        if (this.usePublicSetter(deserializedHeaders, logger)) {
            return;
        }
        boolean declaredFieldAccessibleBackup = this.declaringField.isAccessible();
        try {
            if (!declaredFieldAccessibleBackup) {
                AccessControllerUtils.doPrivileged(() -> {
                    this.declaringField.setAccessible(true);
                    return null;
                });
            }
            this.declaringField.set(deserializedHeaders, this.values);
            logger.verbose("Set header collection by accessing the field directly.");
        }
        catch (IllegalAccessException ex) {
            logger.warning("Failed to inject header collection values into deserialized headers.", new Object[]{ex});
        }
        finally {
            if (!declaredFieldAccessibleBackup) {
                AccessControllerUtils.doPrivileged(() -> {
                    this.declaringField.setAccessible(false);
                    return null;
                });
            }
        }
    }

    private boolean usePublicSetter(Object deserializedHeaders, ClientLogger logger) {
        String fieldName;
        String clazzSimpleName;
        Class<?> clazz = deserializedHeaders.getClass();
        ReflectiveInvoker setterReflectiveInvoker = HeaderCollectionHandler.getFromCache(this.declaringField, clazz, clazzSimpleName = clazz.getSimpleName(), fieldName = this.declaringField.getName(), logger);
        if (setterReflectiveInvoker == NO_SETTER_REFLECTIVE_INVOKER) {
            return false;
        }
        try {
            setterReflectiveInvoker.invokeWithArguments(deserializedHeaders, new Object[]{this.values});
            logger.log(LogLevel.VERBOSE, () -> "Set header collection " + fieldName + " on class " + clazzSimpleName + " using reflection.");
            return true;
        }
        catch (Exception ex) {
            logger.log(LogLevel.VERBOSE, () -> "Failed to set header " + fieldName + " collection on class " + clazzSimpleName + " using reflection.", (Throwable)ex);
            return false;
        }
    }

    private static String getPotentialSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
    }

    private static ReflectiveInvoker getFromCache(Field key, Class<?> clazz, String clazzSimpleName, String fieldName, ClientLogger logger) {
        if (FIELD_TO_SETTER_INVOKER_CACHE.size() >= 10000) {
            FIELD_TO_SETTER_INVOKER_CACHE.clear();
        }
        return FIELD_TO_SETTER_INVOKER_CACHE.computeIfAbsent(key, field -> {
            String setterName = HeaderCollectionHandler.getPotentialSetterName(fieldName);
            try {
                ReflectiveInvoker reflectiveInvoker = ReflectionUtils.getMethodInvoker((Class)clazz, (Method)clazz.getDeclaredMethod(setterName, Map.class));
                logger.log(LogLevel.VERBOSE, () -> "Using invoker for setter " + setterName + " on class " + clazzSimpleName + ".");
                return reflectiveInvoker;
            }
            catch (Exception ex) {
                logger.log(LogLevel.VERBOSE, () -> "Failed to retrieve invoker for setter " + setterName + " on class " + clazzSimpleName + ". Will attempt to make field accessible. Please consider adding public setter.", (Throwable)ex);
                return NO_SETTER_REFLECTIVE_INVOKER;
            }
        });
    }
}

