/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import java.nio.charset.Charset;
import okhttp3.Headers;
import okhttp3.Response;
import reactor.core.publisher.Mono;

abstract class OkHttpAsyncResponseBase
extends HttpResponse {
    private final int statusCode;
    private Headers okhttpHeaders;
    private HttpHeaders headers;

    OkHttpAsyncResponseBase(Response response, HttpRequest request) {
        super(request);
        this.statusCode = response.code();
        this.okhttpHeaders = response.headers();
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHeaderValue(String name) {
        if (this.headers == null) {
            this.headers = OkHttpAsyncResponseBase.fromOkHttpHeaders(this.okhttpHeaders);
            this.okhttpHeaders = null;
        }
        return this.headers.getValue(name);
    }

    public final HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = OkHttpAsyncResponseBase.fromOkHttpHeaders(this.okhttpHeaders);
            this.okhttpHeaders = null;
        }
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    private static HttpHeaders fromOkHttpHeaders(Headers okHttpHeaders) {
        HttpHeaders azureHeaders = new HttpHeaders((int)((float)okHttpHeaders.size() / 0.75f));
        okHttpHeaders.forEach(nameValuePair -> azureHeaders.add((String)nameValuePair.getFirst(), (String)nameValuePair.getSecond()));
        return azureHeaders;
    }
}

