/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.util.CoreUtils;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Locale;

public final class StringUtil {
    public static String getRandomString(String prefix) {
        return String.format(Locale.US, "%s_%s_%s", prefix, CoreUtils.randomUuid().toString().substring(0, 6), Instant.now().toEpochMilli());
    }

    public static String toStackTraceString(Throwable exception, String customErrorMessage) {
        StackTraceElement[] stackTraceElements;
        StringBuilder builder = new StringBuilder();
        if (!CoreUtils.isNullOrEmpty((CharSequence)customErrorMessage)) {
            builder.append(customErrorMessage);
            builder.append(System.lineSeparator());
        }
        builder.append(exception.getMessage());
        for (StackTraceElement ste : stackTraceElements = exception.getStackTrace()) {
            builder.append(System.lineSeparator());
            builder.append(ste.toString());
        }
        Throwable innerException = exception.getCause();
        if (innerException != null) {
            StackTraceElement[] innerStackTraceElements;
            builder.append("Cause: ").append(innerException.getMessage());
            for (StackTraceElement ste : innerStackTraceElements = innerException.getStackTrace()) {
                builder.append(System.lineSeparator());
                builder.append(ste.toString());
            }
        }
        return builder.toString();
    }

    public static String getTrackingIdAndTimeToLog() {
        return String.format(Locale.US, "TrackingId: %s, at: %s", CoreUtils.randomUuid(), ZonedDateTime.now());
    }
}

