/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.implementation.ProtonSession;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ProtonSessionWrapper {
    private static final String SESSION_CHANNEL_CACHE_KEY = "com.azure.core.amqp.cache";
    private final Session sessionUnsafe;
    private final ProtonSession session;
    private final SessionHandler handler;
    private final ReactorProvider provider;

    ProtonSessionWrapper(ProtonSession session) {
        this.session = Objects.requireNonNull(session, "'session' cannot be null.");
        this.handler = null;
        this.provider = null;
        this.sessionUnsafe = null;
    }

    public ProtonSessionWrapper(Session sessionUnsafe, SessionHandler handler, ReactorProvider provider) {
        this.sessionUnsafe = Objects.requireNonNull(sessionUnsafe, "'sessionUnsafe' cannot be null.");
        this.handler = Objects.requireNonNull(handler, "'handler' cannot be null.");
        this.provider = Objects.requireNonNull(provider, "'provider' cannot be null.");
        this.session = null;
    }

    boolean isV2ClientOnSessionCache() {
        return this.session != null;
    }

    String getId() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getId();
        }
        return this.handler.getId();
    }

    String getName() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getName();
        }
        return this.handler.getSessionName();
    }

    String getConnectionId() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getConnectionId();
        }
        return this.handler.getConnectionId();
    }

    String getHostname() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getHostname();
        }
        return this.handler.getHostname();
    }

    Flux<EndpointState> getEndpointStates() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getEndpointStates();
        }
        return this.handler.getEndpointStates();
    }

    ReactorProvider getReactorProvider() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getReactorProvider();
        }
        return this.provider;
    }

    AmqpErrorContext getErrorContext() {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.getErrorContext();
        }
        return this.handler.getErrorContext();
    }

    void openUnsafe(ClientLogger logger) {
        if (this.isV2ClientOnSessionCache()) {
            throw logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Requires v2 client without com.azure.core.amqp.cache or v1 client."));
        }
        this.sessionUnsafe.open();
    }

    Mono<Void> open() {
        if (!this.isV2ClientOnSessionCache()) {
            return Mono.error((Throwable)new UnsupportedOperationException("open() requires v2 client with com.azure.core.amqp.cache"));
        }
        return this.session.open();
    }

    Mono<ProtonChannelWrapper> channel(String name, Duration timeout) {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.channel(name, timeout).map(ProtonChannelWrapper::new);
        }
        return Mono.just((Object)new ProtonChannelWrapper(name, this.sessionUnsafe));
    }

    Sender senderUnsafe(String name) {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.senderUnsafe(name);
        }
        return this.sessionUnsafe.sender(name);
    }

    Receiver receiverUnsafe(String name) {
        if (this.isV2ClientOnSessionCache()) {
            return this.session.receiverUnsafe(name);
        }
        return this.sessionUnsafe.receiver(name);
    }

    void beginClose(ErrorCondition condition) {
        if (this.isV2ClientOnSessionCache()) {
            this.session.beginClose(condition);
        } else if (this.sessionUnsafe.getLocalState() != EndpointState.CLOSED) {
            this.sessionUnsafe.close();
            if (condition != null && this.sessionUnsafe.getCondition() == null) {
                this.sessionUnsafe.setCondition(condition);
            }
        }
    }

    void endClose() {
        if (this.isV2ClientOnSessionCache()) {
            this.session.endClose();
        } else {
            this.handler.close();
        }
    }

    static final class ProtonChannelWrapper {
        private final String name;
        private final Sender sender;
        private final Receiver receiver;

        ProtonChannelWrapper(ProtonSession.ProtonChannel channel) {
            Objects.requireNonNull(channel, "'channel' cannot be null.");
            this.name = channel.getName();
            this.sender = channel.getSender();
            this.receiver = channel.getReceiver();
        }

        ProtonChannelWrapper(String name, Session sessionUnsafe) {
            this.name = Objects.requireNonNull(name, "'name' cannot be null.");
            Objects.requireNonNull(sessionUnsafe, "'sessionUnsafe' cannot be null.");
            this.sender = sessionUnsafe.sender(name + ":sender");
            this.receiver = sessionUnsafe.receiver(name + ":receiver");
        }

        String getName() {
            return this.name;
        }

        Sender sender() {
            return this.sender;
        }

        Receiver receiver() {
            return this.receiver;
        }
    }
}

