/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.util.logging.ClientLogger;
import java.io.UncheckedIOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;

abstract class CreditAccountingStrategy {
    private final AmqpReceiveLink receiver;
    protected final ClientLogger logger;
    protected final Subscription subscription;
    protected final int prefetch;

    protected CreditAccountingStrategy(AmqpReceiveLink receiver, Subscription subscription, int prefetch, ClientLogger logger) {
        this.receiver = receiver;
        this.subscription = subscription;
        this.prefetch = prefetch;
        this.logger = logger;
    }

    abstract void update(long var1, long var3);

    protected void scheduleCredit(Supplier<Long> creditSupplier) {
        try {
            this.receiver.addCredit(creditSupplier);
        }
        catch (RejectedExecutionException e) {
            this.log("Scheduling credit flow encountered rejected-error (normal during link termination or transition).", e);
        }
        catch (UncheckedIOException e) {
            this.log("Scheduling credit flow encountered io-error (normal during link termination or transition).", e);
        }
    }

    private void log(String message, RuntimeException e) {
        this.logger.atInfo().addKeyValue("connectionId", this.receiver.getConnectionId()).addKeyValue("linkName", this.receiver.getLinkName()).addKeyValue("entityPath", this.receiver.getEntityPath()).log(message, new Object[]{e});
    }
}

